/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.responses.AsyncCallback;
import tigase.criteria.Criteria;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.component.AbstractEventBusModule;
import tigase.disteventbus.component.ElemPathCriteria;
import tigase.disteventbus.component.EventBusContext;
import tigase.disteventbus.component.NodeNameUtil;
import tigase.disteventbus.component.stores.Affiliation;
import tigase.disteventbus.component.stores.Subscription;
import tigase.disteventbus.impl.EventName;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class SubscribeModule
extends AbstractEventBusModule {
    public static final String ID = "subscribe";
    private static final Criteria CRIT = new ElemPathCriteria(new String[]{"iq", "pubsub", "subscribe"}, new String[]{null, "http://jabber.org/protocol/pubsub", null});
    private final EventHandler eventBusHandlerAddedHandler = new EventHandler(){
        private final String[] NAME_PATH = new String[]{"HandlerAdded", "name"};
        private final String[] XMLNS_PATH = new String[]{"HandlerAdded", "xmlns"};

        @Override
        public void onEvent(String name, String xmlns, Element event) {
            String n = event.getCData(this.NAME_PATH);
            String x = event.getCData(this.XMLNS_PATH);
            if (x == null || !x.equals("tigase:eventbus:internal:events:0")) {
                SubscribeModule.this.onAddHandler(n, x);
            }
        }
    };

    @Override
    public void afterRegistration() {
        super.afterRegistration();
        ((EventBusContext)this.context).getEventBusInstance().addHandler("HandlerAdded", "tigase:eventbus:internal:events:0", this.eventBusHandlerAddedHandler);
    }

    public void clusterNodeConnected(JID node) {
        if (((EventBusContext)this.context).getComponentID().equals(node)) {
            return;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Node " + node + " is connected. Preparing subscribe request.");
        }
        HashSet<Element> pubsubNodes = new HashSet<Element>();
        for (EventName eventName : ((EventBusContext)this.context).getEventBusInstance().getAllListenedEvents()) {
            pubsubNodes.add(this.prepareSubscribeElement(eventName, ((EventBusContext)this.context).getComponentID(), null));
        }
        for (EventName eventName : ((EventBusContext)this.context).getSubscriptionStore().getSubscribedEvents()) {
            Collection<Subscription> subscriptions = ((EventBusContext)this.context).getSubscriptionStore().getSubscribersJIDs(eventName.getName(), eventName.getXmlns());
            for (Subscription subscription : subscriptions) {
                if (subscription.getServiceJID() == null) continue;
                pubsubNodes.add(this.prepareSubscribeElement(eventName, subscription.getJid(), subscription.getServiceJID().toString()));
            }
        }
        if (!pubsubNodes.isEmpty()) {
            this.sendSubscribeRequest("eventbus@" + node.getDomain(), pubsubNodes);
        }
    }

    public void clusterNodeDisconnected(JID node) {
        if (((EventBusContext)this.context).getComponentID().equals(node)) {
            return;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Node " + node + " is disconnected.");
        }
        ((EventBusContext)this.context).getSubscriptionStore().remove(new Subscription(JID.jidInstanceNS("eventbus", node.getDomain(), null)));
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#subscribe"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    protected void onAddHandler(String eventName, String eventXmlns) {
        for (JID node : ((EventBusContext)this.context).getConnectedNodes()) {
            if (((EventBusContext)this.context).getComponentID().equals(node)) continue;
            Element se = this.prepareSubscribeElement(new EventName(eventName, eventXmlns), ((EventBusContext)this.context).getComponentID(), null);
            this.sendSubscribeRequest("eventbus@" + node.getDomain(), Collections.singleton(se));
        }
    }

    private Element prepareSubscribeElement(EventName event, JID jid, String service) {
        Element subscribeElem = new Element(ID);
        subscribeElem.addAttribute("node", event.toEventBusNode());
        subscribeElem.addAttribute("jid", jid.toString());
        if (service != null) {
            subscribeElem.addChild(new Element("service", service));
        }
        return subscribeElem;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getType() != StanzaType.set) {
            throw new ComponentException(Authorization.NOT_ALLOWED, "Only type set is allowed.");
        }
        this.processSet(packet);
    }

    protected Element processClusterSubscription(Packet packet) throws TigaseStringprepException {
        this.log.finest("Processing cluster subscription request from " + packet.getStanzaFrom());
        List<Element> subscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        for (Element subscribe : subscribeElements) {
            Element serviceItem = subscribe.getChild("service");
            EventName parsedName = NodeNameUtil.parseNodeName(subscribe.getAttributeStaticStr("node"));
            JID jid = JID.jidInstance(subscribe.getAttributeStaticStr("jid"));
            String service = serviceItem != null && serviceItem.getCData() != null ? serviceItem.getCData() : null;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Node " + jid + " subscribed for events " + parsedName);
            }
            Subscription subscription = new Subscription(jid);
            subscription.setInClusterSubscription(true);
            subscription.setServiceJID(JID.jidInstanceNS(service));
            ((EventBusContext)this.context).getSubscriptionStore().addSubscription(parsedName.getName(), parsedName.getXmlns(), subscription);
        }
        return null;
    }

    protected Element processNonClusterSubscription(Packet packet) throws TigaseStringprepException, ComponentException {
        Affiliation affiliation;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Processing noncluster subscription request from " + packet.getStanzaFrom());
        }
        if (!(affiliation = ((EventBusContext)this.context).getAffiliationStore().getAffiliation(packet.getStanzaFrom())).isSubscribe()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Subscription rejected. Subscriber " + packet.getStanzaFrom() + " has bad affiliation: " + (Object)((Object)affiliation));
            }
            throw new ComponentException(Authorization.FORBIDDEN, "Bad affiliation: " + (Object)((Object)affiliation));
        }
        List<Element> subscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        Element response = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        HashSet<Element> subscribedNodes = new HashSet<Element>();
        for (Element subscribe : subscribeElements) {
            EventName parsedName = NodeNameUtil.parseNodeName(subscribe.getAttributeStaticStr("node"));
            JID jid = JID.jidInstance(subscribe.getAttributeStaticStr("jid"));
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Entity " + jid + " subscribed for events " + parsedName);
            }
            Subscription subscription = new Subscription(jid, packet.getStanzaTo());
            subscription.setInClusterSubscription(false);
            ((EventBusContext)this.context).getSubscriptionStore().addSubscription(parsedName.getName(), parsedName.getXmlns(), subscription);
            subscribedNodes.add(this.prepareSubscribeElement(parsedName, jid, packet.getStanzaTo().toString()));
            response.addChild(new Element("subscription", new String[]{"node", "jid", "subscription"}, new String[]{parsedName.toEventBusNode(), jid.toString(), "subscribed"}));
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Forwarding subscription request to: " + ((EventBusContext)this.context).getConnectedNodes());
        }
        for (JID node : ((EventBusContext)this.context).getConnectedNodes()) {
            if (((EventBusContext)this.context).getComponentID().equals(node)) continue;
            this.sendSubscribeRequest("eventbus@" + node.getDomain(), subscribedNodes);
        }
        return response;
    }

    private void processSet(Packet packet) throws TigaseStringprepException, ComponentException {
        Element subscriptionResponse = this.isClusteredEventBus(packet.getStanzaFrom()) ? this.processClusterSubscription(packet) : this.processNonClusterSubscription(packet);
        Packet response = packet.okResult(subscriptionResponse, 0);
        response.setPermissions(Permissions.ADMIN);
        this.write(response);
    }

    protected void sendSubscribeRequest(final String to, Collection<Element> subscriptionElements) {
        try {
            String id = this.nextStanzaID();
            Element iq = new Element("iq", new String[]{"from", "to", "type", "id"}, new String[]{((EventBusContext)this.context).getComponentID().toString(), to, "set", id});
            Element pubsubElem = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            iq.addChild(pubsubElem);
            subscriptionElements.forEach(pubsubElem::addChild);
            Packet packet = Packet.packetInstance(iq);
            packet.setPermissions(Permissions.ADMIN);
            packet.setXMLNS("jabber:client");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Sending subscribe request (id=" + id + ") to node " + to);
            }
            this.write(packet, new AsyncCallback(){

                @Override
                public void onError(Packet responseStanza, String errorCondition) {
                    if (SubscribeModule.this.log.isLoggable(Level.FINE)) {
                        SubscribeModule.this.log.fine("Subscription request was cancelled by node " + to + " with error " + errorCondition);
                    }
                }

                @Override
                public void onSuccess(Packet responseStanza) {
                    if (SubscribeModule.this.log.isLoggable(Level.FINE)) {
                        SubscribeModule.this.log.fine("Subscription request was accepted by node " + to + ".");
                    }
                }

                @Override
                public void onTimeout() {
                    if (SubscribeModule.this.log.isLoggable(Level.FINE)) {
                        SubscribeModule.this.log.fine("Subscription request timeout. Node " + to + " not answered.");
                    }
                }
            });
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Why? Oh Why?", e);
        }
    }

    @Override
    public void unregisterModule() {
        ((EventBusContext)this.context).getEventBusInstance().removeHandler("HandlerAdded", "tigase:eventbus:internal:events:0", this.eventBusHandlerAddedHandler);
        super.unregisterModule();
    }
}

