/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.responses;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import tigase.component.Context;
import tigase.component.responses.AsyncCallback;
import tigase.component.responses.DefaultResponseHandler;
import tigase.server.Packet;
import tigase.xmpp.JID;

public class ResponseManager {
    public static final long DEFAULT_TIMEOUT = 60000L;
    private final Map<String, Entry> handlers = new HashMap<String, Entry>();
    protected final Logger log = Logger.getLogger(this.getClass().getName());

    public ResponseManager(Context context) {
    }

    public void checkTimeouts() {
        long now = new Date().getTime();
        Iterator<Map.Entry<String, Entry>> it = this.getHandlers().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Entry> e = it.next();
            if (e.getValue().timestamp + e.getValue().timeout >= now) continue;
            it.remove();
            e.getValue().callback.onTimeout();
        }
    }

    protected Map<String, Entry> getHandlers() {
        return this.handlers;
    }

    public Runnable getResponseHandler(Packet element) {
        if (!"iq".equals(element.getElemName())) {
            return null;
        }
        String type = element.getElement().getAttributeStaticStr("type");
        if (type == null || type.equals("set") || type.equals("get")) {
            return null;
        }
        String id = element.getElement().getAttributeStaticStr("id");
        if (id == null) {
            return null;
        }
        Entry entry = this.getHandlers().get(id);
        if (entry == null) {
            return null;
        }
        if (!this.verify(element, entry)) {
            return null;
        }
        this.getHandlers().remove(id);
        DefaultResponseHandler r = new DefaultResponseHandler(element, entry);
        return r;
    }

    public String registerResponseHandler(Packet stanza, Long timeout, AsyncCallback callback) {
        if (stanza == null) {
            return null;
        }
        JID to = stanza.getStanzaTo();
        String id = stanza.getElement().getAttributeStaticStr("id");
        if (id == null) {
            id = UUID.randomUUID().toString();
            stanza.getElement().setAttribute("id", id);
        }
        if (callback != null) {
            Entry entry = new Entry(to, new Date().getTime(), timeout == null ? 60000L : timeout, callback);
            this.getHandlers().put(id, entry);
        }
        return id;
    }

    private boolean verify(Packet response, Entry entry) {
        JID jid = response.getStanzaFrom();
        if (jid != null && entry.jid != null && jid.getBareJID().equals(entry.jid.getBareJID())) {
            return true;
        }
        return entry.jid == null && jid == null;
    }

    protected static final class Entry {
        private final AsyncCallback callback;
        private final JID jid;
        private final long timeout;
        private final long timestamp;

        public Entry(JID jid, long timestamp, long timeout, AsyncCallback callback) {
            this.jid = jid;
            this.timestamp = timestamp;
            this.timeout = timeout;
            this.callback = callback;
        }

        AsyncCallback getCallback() {
            return this.callback;
        }

        JID getJid() {
            return this.jid;
        }

        long getTimeout() {
            return this.timeout;
        }

        long getTimestamp() {
            return this.timestamp;
        }
    }
}

