/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules.impl;

import java.util.List;
import tigase.component.Context;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.AbstractModule;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;

public class DiscoveryModule<CTX extends Context>
extends AbstractModule<CTX> {
    public static final String DISCO_INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    public static final String DISCO_ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    public static final String ID = "disco";
    private Criteria criteria = ElementCriteria.nameType("iq", "get").add(new Or(ElementCriteria.name("query", "http://jabber.org/protocol/disco#info"), ElementCriteria.name("query", "http://jabber.org/protocol/disco#items")));

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return this.criteria;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        block6: {
            Element q = packet.getElement().getChild("query");
            JID senderJID = packet.getStanzaFrom();
            JID jid = packet.getStanzaTo();
            String node = q.getAttributeStaticStr("node");
            try {
                if (q.getXMLNS().equals(DISCO_INFO_XMLNS)) {
                    this.processDiscoInfo(packet, jid, node, senderJID);
                    break block6;
                }
                if (q.getXMLNS().equals(DISCO_ITEMS_XMLNS) && node != null && node.equals("http://jabber.org/protocol/commands")) {
                    this.processAdHocCommandItems(packet, jid, node, senderJID);
                    break block6;
                }
                if (q.getXMLNS().equals(DISCO_ITEMS_XMLNS)) {
                    this.processDiscoItems(packet, jid, node, senderJID);
                    break block6;
                }
                throw new ComponentException(Authorization.BAD_REQUEST);
            }
            catch (ComponentException e) {
                throw e;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processAdHocCommandItems(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        AdHocCommandModule module = (AdHocCommandModule)this.context.getModuleProvider().getModule("commands");
        if (module == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND);
        }
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{DISCO_ITEMS_XMLNS});
        Packet result = packet.okResult(resultQuery, 0);
        List<Element> items = module.getScriptItems(node, packet.getStanzaTo(), packet.getStanzaFrom());
        resultQuery.addChildren(items);
        this.write(result);
    }

    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{DISCO_INFO_XMLNS});
        Packet resultIq = packet.okResult(resultQuery, 0);
        resultQuery.addChild(new Element("identity", new String[]{"category", "type", "name"}, new String[]{this.context.getDiscoCategory(), this.context.getDiscoCategoryType(), this.context.getDiscoDescription()}));
        for (String f : this.context.getModuleProvider().getAvailableFeatures()) {
            resultQuery.addChild(new Element("feature", new String[]{"var"}, new String[]{f}));
        }
        this.write(resultIq);
    }

    protected void processDiscoItems(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{DISCO_ITEMS_XMLNS});
        this.write(packet.okResult(resultQuery, 0));
    }
}

