/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.adhoc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdHocSession;
import tigase.component.adhoc.AdhHocRequest;
import tigase.server.Packet;
import tigase.util.SimpleCache;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class AdHocCommandManager {
    private final Map<String, AdHocCommand> commands = new HashMap<String, AdHocCommand>();
    private final SimpleCache<String, AdHocSession> sessions = new SimpleCache(100, 10000L);

    public Collection<AdHocCommand> getAllCommands() {
        return this.commands.values();
    }

    public AdHocCommand getCommand(String nodeName) {
        return this.commands.get(nodeName);
    }

    public boolean hasCommand(String node) {
        return this.commands.containsKey(node);
    }

    public Packet process(Packet packet) throws AdHocCommandException {
        Element element = packet.getElement();
        JID senderJid = packet.getStanzaFrom();
        Element command2 = element.getChild("command", "http://jabber.org/protocol/commands");
        String node = command2.getAttributeStaticStr("node");
        String action = command2.getAttributeStaticStr("action");
        String sessionId = command2.getAttributeStaticStr("sessionid");
        AdHocCommand adHocCommand = this.getCommand(node);
        if (adHocCommand != null) {
            return this.process(packet, command2, node, action, sessionId, adHocCommand);
        }
        return null;
    }

    public Packet process(Packet packet, Element commandElement, String node, String action, String sessionId, AdHocCommand adHocCommand) throws AdHocCommandException {
        AdHocResponse.State currentState = null;
        AdhHocRequest request = new AdhHocRequest(packet, commandElement, node, packet.getStanzaFrom(), action, sessionId);
        AdHocResponse response = new AdHocResponse(sessionId, currentState);
        AdHocSession session = sessionId == null ? new AdHocSession() : this.sessions.get(sessionId);
        adHocCommand.execute(request, response);
        Element commandResult = new Element("command", new String[]{"xmlns", "node"}, new String[]{"http://jabber.org/protocol/commands", node});
        commandResult.addAttribute("status", response.getNewState().name());
        if (response.getCurrentState() == null && response.getNewState() == AdHocResponse.State.executing) {
            this.sessions.put(response.getSessionid(), session);
        } else if (response.getSessionid() != null && (response.getNewState() == AdHocResponse.State.canceled || response.getNewState() == AdHocResponse.State.completed)) {
            this.sessions.remove(response.getSessionid());
        }
        if (response.getSessionid() != null) {
            commandResult.addAttribute("sessionid", response.getSessionid());
        }
        for (Element r : response.getElements()) {
            commandResult.addChild(r);
        }
        return packet.okResult(commandResult, 0);
    }

    public void registerCommand(AdHocCommand command2) {
        if (!this.commands.containsKey(command2.getNode())) {
            this.commands.put(command2.getNode(), command2);
        }
    }
}

