/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.api;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ClusterElement {
    public static final String CLUSTER_CONTROL_EL_NAME = "control";
    public static final String CLUSTER_DATA_EL_NAME = "data";
    public static final String CLUSTER_EL_NAME = "cluster";
    public static final String CLUSTER_METHOD_EL_NAME = "method-call";
    public static final String CLUSTER_METHOD_PAR_EL_NAME = "par";
    public static final String CLUSTER_METHOD_RESULTS_EL_NAME = "results";
    public static final String CLUSTER_METHOD_RESULTS_VAL_EL_NAME = "val";
    public static final String CLUSTER_NAME_ATTR = "name";
    public static final String FIRST_NODE_EL_NAME = "first-node";
    public static final String NODE_ID_EL_NAME = "node-id";
    public static final String VISITED_NODES_EL_NAME = "visited-nodes";
    public static final String XMLNS = "tigase:cluster";
    private static final Logger log = Logger.getLogger("tigase.cluster.ClusterElement");
    public static final String[] VISITED_NODES_PATH = new String[]{"cluster", "control", "visited-nodes"};
    public static final String[] FIRST_NODE_PATH = new String[]{"cluster", "control", "first-node"};
    public static final String[] CLUSTER_METHOD_RESULTS_PATH = new String[]{"cluster", "control", "method-call", "results"};
    public static final String[] CLUSTER_METHOD_PATH = new String[]{"cluster", "control", "method-call"};
    public static final String[] CLUSTER_DATA_PATH = new String[]{"cluster", "data"};
    public static final String[] CLUSTER_CONTROL_PATH = new String[]{"cluster", "control"};
    private Element elem = null;
    private JID first_node = null;
    private String method_name = null;
    private Map<String, String> method_params = null;
    private Map<String, String> method_results = null;
    private Queue<Element> packets = null;
    private Priority priority = null;
    private Set<JID> visited_nodes = null;

    public ClusterElement(Element elem) {
        Element method_call;
        String fNode;
        List<Element> children;
        this.elem = elem;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Parsing cluster element: " + elem.toString());
        }
        if ((children = elem.getChildrenStaticStr(CLUSTER_DATA_PATH)) != null && children.size() > 0) {
            this.packets = new ArrayDeque<Element>(children);
        }
        if ((fNode = elem.getCDataStaticStr(FIRST_NODE_PATH)) != null) {
            this.first_node = JID.jidInstanceNS(fNode);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("First node found: " + this.first_node);
        }
        this.visited_nodes = new LinkedHashSet<JID>();
        List<Element> nodes = elem.getChildrenStaticStr(VISITED_NODES_PATH);
        if (nodes != null) {
            int cnt = 0;
            for (Element node : nodes) {
                this.visited_nodes.add(JID.jidInstanceNS(node.getCData()));
                ++cnt;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found and added visited nodes: " + cnt);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("No visited nodes found");
        }
        String priorityStr = elem.getAttributeStaticStr("pr");
        if (priorityStr != null) {
            this.priority = Priority.valueOf(priorityStr);
        }
        if ((method_call = elem.findChildStaticStr(CLUSTER_METHOD_PATH)) != null) {
            this.parseMethodCall(method_call);
        }
    }

    public ClusterElement(JID from, JID to, StanzaType type, Packet packet) {
        if (packet != null) {
            this.packets = new ArrayDeque<Element>();
            this.visited_nodes = new LinkedHashSet<JID>();
            this.elem = ClusterElement.createClusterElement(from, to, type, packet.getFrom().toString());
            if (packet.getElement().getXMLNS() == null) {
                packet.getElement().setXMLNS("jabber:client");
            }
            this.addDataPacket(packet);
        }
    }

    public static Element clusterElement(JID from, JID to, StanzaType type) {
        Element cluster_el = new Element(CLUSTER_EL_NAME, new String[]{"from", "to", "type"}, new String[]{from.toString(), to.toString(), type.toString()});
        cluster_el.setXMLNS(XMLNS);
        cluster_el.addChild(new Element(CLUSTER_CONTROL_EL_NAME, new Element[]{new Element(VISITED_NODES_EL_NAME)}, null, null));
        return cluster_el;
    }

    public static Element createClusterElement(JID from, JID to, StanzaType type, String packet_from) {
        Element cluster_el = ClusterElement.clusterElement(from, to, type);
        cluster_el.addChild(new Element(CLUSTER_DATA_EL_NAME));
        return cluster_el;
    }

    public static ClusterElement createClusterMethodCall(JID from, JID to, StanzaType type, String method_name, Map<String, String> params) {
        Element cluster_el = ClusterElement.clusterElement(from, to, type);
        Element method_call = new Element(CLUSTER_METHOD_EL_NAME, new String[]{CLUSTER_NAME_ATTR}, new String[]{method_name});
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                method_call.addChild(new Element(CLUSTER_METHOD_PAR_EL_NAME, entry.getValue(), new String[]{CLUSTER_NAME_ATTR}, new String[]{entry.getKey()}));
            }
        }
        cluster_el.findChildStaticStr(CLUSTER_CONTROL_PATH).addChild(method_call);
        ClusterElement result_cl = new ClusterElement(cluster_el);
        result_cl.addVisitedNode(from);
        return result_cl;
    }

    public static ClusterElement createForNextNode(ClusterElement clel, List<JID> cluster_nodes, JID comp_id) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Calculating a next node from nodes: " + (cluster_nodes != null ? cluster_nodes.toString() : "null"));
        }
        if (cluster_nodes != null && cluster_nodes.size() > 0) {
            JID next_node = null;
            for (JID cluster_node : cluster_nodes) {
                if (clel.isVisitedNode(cluster_node) || cluster_node.equals(comp_id)) continue;
                next_node = cluster_node;
                if (!log.isLoggable(Level.FINEST)) break;
                log.finest("Found next cluster node: " + next_node);
                break;
            }
            if (next_node != null) {
                ClusterElement result = clel.nextClusterNode(next_node);
                result.addVisitedNode(comp_id);
                return result;
            }
        }
        return null;
    }

    public void addDataPacket(Packet packet) {
        this.addDataPacket(packet.getElement());
    }

    public void addDataPacket(Element packet) {
        if (this.packets == null) {
            this.packets = new ArrayDeque<Element>();
        }
        this.packets.offer(packet);
        if (this.elem.findChildStaticStr(CLUSTER_DATA_PATH) == null) {
            this.elem.addChild(new Element(CLUSTER_DATA_EL_NAME));
        }
        this.elem.findChildStaticStr(CLUSTER_DATA_PATH).addChild(packet);
    }

    public void addDataPackets(Queue<Element> packets) {
        if (packets != null) {
            for (Element elem : packets) {
                this.addDataPacket(elem);
            }
        }
    }

    public void addMethodResult(String key, String val) {
        Element res = this.elem.findChildStaticStr(CLUSTER_METHOD_RESULTS_PATH);
        if (res == null) {
            res = new Element(CLUSTER_METHOD_RESULTS_EL_NAME);
            this.elem.findChildStaticStr(CLUSTER_METHOD_PATH).addChild(res);
        }
        res.addChild(new Element(CLUSTER_METHOD_RESULTS_VAL_EL_NAME, val, new String[]{CLUSTER_NAME_ATTR}, new String[]{key}));
        if (this.method_results == null) {
            this.method_results = new LinkedHashMap<String, String>();
        }
        this.method_results.put(key, val);
    }

    public void addVisitedNode(JID node_id) {
        if (this.visited_nodes.size() == 0) {
            this.first_node = node_id;
            this.elem.findChildStaticStr(CLUSTER_CONTROL_PATH).addChild(new Element(FIRST_NODE_EL_NAME, node_id.toString()));
        }
        if (this.visited_nodes.add(node_id)) {
            this.elem.findChildStaticStr(VISITED_NODES_PATH).addChild(new Element(NODE_ID_EL_NAME, node_id.toString()));
        }
    }

    public void addVisitedNodes(Set<JID> nodes) {
        if (nodes != null) {
            for (JID node : nodes) {
                this.addVisitedNode(node);
            }
        }
    }

    public ClusterElement createMethodResponse(JID from, StanzaType type, Map<String, String> results) {
        return this.createMethodResponse(from, null, type, results);
    }

    public ClusterElement createMethodResponse(JID from, JID to, StanzaType type, Map<String, String> results) {
        Element result_el = this.elem.clone();
        result_el.setAttribute("from", from.toString());
        result_el.setAttribute("to", to != null ? to.toString() : this.first_node.toString());
        result_el.setAttribute("type", type.name());
        Element res = new Element(CLUSTER_METHOD_RESULTS_EL_NAME);
        result_el.findChildStaticStr(CLUSTER_METHOD_PATH).addChild(res);
        ClusterElement result_cl = new ClusterElement(result_el);
        if (results != null) {
            for (Map.Entry<String, String> entry : results.entrySet()) {
                result_cl.addMethodResult(entry.getKey(), entry.getValue());
            }
        }
        return result_cl;
    }

    public Map<String, String> getAllMethodParams() {
        return this.method_params;
    }

    public Map<String, String> getAllMethodResults() {
        return this.method_results;
    }

    public Element getClusterElement(String id) {
        this.elem.setAttribute("id", id);
        return this.elem;
    }

    public Queue<Element> getDataPackets() {
        return this.packets;
    }

    public JID getFirstNode() {
        return this.first_node;
    }

    public String getMethodName() {
        return this.method_name;
    }

    public String getMethodParam(String par_name) {
        return this.method_params == null ? null : this.method_params.get(par_name);
    }

    public long getMethodParam(String par_name, long def) {
        String val_str = this.getMethodParam(par_name);
        if (val_str == null) {
            return def;
        }
        try {
            return Long.parseLong(val_str);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public String getMethodResultVal(String val_name) {
        return this.method_results == null ? null : this.method_results.get(val_name);
    }

    public long getMethodResultVal(String val_name, long def) {
        String val_str = this.getMethodResultVal(val_name);
        if (val_str == null) {
            return def;
        }
        try {
            return Long.parseLong(val_str);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Set<JID> getVisitedNodes() {
        return this.visited_nodes;
    }

    public boolean isVisitedNode(JID node_id) {
        return this.visited_nodes.contains(node_id);
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
        this.elem.setAttribute("pr", priority.name());
    }

    public ClusterElement nextClusterNode(JID node_id) {
        Element next_el = this.elem.clone();
        String from = this.elem.getAttributeStaticStr("to");
        next_el.setAttribute("from", from);
        next_el.setAttribute("to", node_id.toString());
        ClusterElement next_cl = new ClusterElement(next_el);
        return next_cl;
    }

    protected void parseMethodCall(Element method_call) {
        this.method_name = method_call.getAttributeStaticStr(CLUSTER_NAME_ATTR);
        if (this.method_name != null) {
            this.method_name = this.method_name.intern();
        }
        this.method_params = new LinkedHashMap<String, String>();
        List<Element> children = method_call.getChildren();
        if (children != null) {
            for (Element child : children) {
                List<Element> res_children;
                if (child.getName() == CLUSTER_METHOD_PAR_EL_NAME) {
                    String par_name = child.getAttributeStaticStr(CLUSTER_NAME_ATTR);
                    this.method_params.put(par_name, child.getCData());
                }
                if (child.getName() != CLUSTER_METHOD_RESULTS_EL_NAME) continue;
                if (this.method_results == null) {
                    this.method_results = new LinkedHashMap<String, String>();
                }
                if ((res_children = child.getChildren()) == null) continue;
                for (Element res_child : res_children) {
                    if (res_child.getName() != CLUSTER_METHOD_RESULTS_VAL_EL_NAME) continue;
                    String val_name = res_child.getAttributeStaticStr(CLUSTER_NAME_ATTR);
                    this.method_results.put(val_name, res_child.getCData());
                }
            }
        }
    }
}

