/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import tigase.auth.XmppSaslException;
import tigase.auth.callbacks.VerifyPasswordCallback;
import tigase.auth.mechanisms.AbstractSasl;

public class SaslPLAIN
extends AbstractSasl {
    private static final String MECHANISM = "PLAIN";

    SaslPLAIN(Map<? super String, ?> props, CallbackHandler callbackHandler) {
        super(props, callbackHandler);
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String[] data = this.split(response, "");
        if (data.length != 3) {
            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Invalid number of message parts");
        }
        String authzid = data[0];
        String authcid = data[1];
        String passwd = data[2];
        if (authcid.length() < 1) {
            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Authentication identity string is empty");
        }
        if (authcid.length() > 255) {
            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Authentication identity string is too long");
        }
        if (!SaslPLAIN.isEmpty(authzid) && authzid.length() > 255) {
            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Authorization identity string is too long");
        }
        if (passwd.length() > 255) {
            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Password string is too long");
        }
        NameCallback nc = new NameCallback("Authentication identity", authcid);
        VerifyPasswordCallback vpc = new VerifyPasswordCallback(passwd);
        this.handleCallbacks(nc, vpc);
        if (!vpc.isVerified()) {
            throw new XmppSaslException(XmppSaslException.SaslError.not_authorized, "Password not verified");
        }
        String authorizationJID = SaslPLAIN.isEmpty(authzid) ? nc.getName() : authzid;
        AuthorizeCallback ac = new AuthorizeCallback(nc.getName(), authorizationJID);
        this.handleCallbacks(ac);
        if (!ac.isAuthorized()) {
            throw new XmppSaslException(XmppSaslException.SaslError.invalid_authzid, "PLAIN: " + authcid + " is not authorized to act as " + authorizationJID);
        }
        this.authorizedId = ac.getAuthorizedID();
        this.complete = true;
        return null;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizedId;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return null;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return null;
    }
}

