/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import tigase.auth.XmppSaslException;
import tigase.auth.callbacks.ValidateCertificateData;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

public class SaslEXTERNAL
extends AbstractSasl {
    private static final String MECHANISM = "EXTERNAL";
    public static final String PEER_CERTIFICATE_KEY = "PEER_CERTIFICATE_ENTRY_KEY";

    SaslEXTERNAL(Map<? super String, ?> props, CallbackHandler callbackHandler) {
        super(props, callbackHandler);
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        BareJID jid;
        try {
            jid = response != null && response.length > 0 ? BareJID.bareJIDInstance(new String(response)) : null;
        }
        catch (TigaseStringprepException e) {
            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
        }
        ValidateCertificateData ac = new ValidateCertificateData(jid);
        this.handleCallbacks(ac);
        if (!ac.isAuthorized()) {
            throw new XmppSaslException(XmppSaslException.SaslError.invalid_authzid);
        }
        this.authorizedId = ac.getAuthorizedID();
        this.complete = true;
        return null;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizedId;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return null;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return null;
    }
}

