/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.SessionAware;
import tigase.auth.callbacks.ChannelBindingCallback;
import tigase.auth.callbacks.PBKDIterationsCallback;
import tigase.auth.callbacks.SaltCallback;
import tigase.auth.callbacks.SaltedPasswordCallback;
import tigase.auth.callbacks.XMPPSessionCallback;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.db.AuthRepository;
import tigase.util.Base64;
import tigase.xmpp.BareJID;
import tigase.xmpp.XMPPResourceConnection;

public class ScramCallbackHandler
implements CallbackHandler,
AuthRepositoryAware,
SessionAware,
DomainAware {
    private final SecureRandom random = new SecureRandom();
    private final byte[] salt;
    protected BareJID jid = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private String domain;
    private int pbkd2Iterations = 4096;
    private AuthRepository repo;
    private XMPPResourceConnection session;

    public ScramCallbackHandler() {
        this.salt = new byte[10];
        this.random.nextBytes(this.salt);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
            }
            this.handleCallback(callbacks[i]);
        }
    }

    protected void handleAuthorizeCallback(AuthorizeCallback authCallback) {
        String authenId = authCallback.getAuthenticationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
        }
        String authorId = authCallback.getAuthorizationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
        }
        if (AbstractSasl.isAuthzIDIgnored() || authenId.equals(authorId)) {
            authCallback.setAuthorized(true);
        }
    }

    protected void handleCallback(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof XMPPSessionCallback) {
            ((XMPPSessionCallback)callback).setSession(this.session);
        } else if (callback instanceof ChannelBindingCallback) {
            this.handleChannelBindingCallback((ChannelBindingCallback)callback);
        } else if (callback instanceof PBKDIterationsCallback) {
            this.handlePBKDIterationsCallback((PBKDIterationsCallback)callback);
        } else if (callback instanceof SaltedPasswordCallback) {
            this.handleSaltedPasswordCallbackCallback((SaltedPasswordCallback)callback);
        } else if (callback instanceof NameCallback) {
            this.handleNameCallback((NameCallback)callback);
        } else if (callback instanceof SaltCallback) {
            this.handleSaltCallback((SaltCallback)callback);
        } else if (callback instanceof AuthorizeCallback) {
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback " + callback);
        }
    }

    private void handleChannelBindingCallback(ChannelBindingCallback callback) {
        if (callback.getRequestedBindType() == AbstractSaslSCRAM.BindType.tls_unique) {
            callback.setBindingData((byte[])this.session.getSessionData("TLS_UNIQUE_ID_KEY"));
        } else if (callback.getRequestedBindType() == AbstractSaslSCRAM.BindType.tls_server_end_point) {
            try {
                Certificate cert = (Certificate)this.session.getSessionData("LOCAL_CERTIFICATE_KEY");
                String algo = cert.getPublicKey().getAlgorithm();
                String usealgo = algo.equals("MD5") || algo.equals("SHA-1") ? "SHA-256" : algo;
                MessageDigest md = MessageDigest.getInstance(usealgo);
                byte[] der = cert.getEncoded();
                md.update(der);
                callback.setBindingData(md.digest());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Channel binding {0}: {1} in session-id {2}", new Object[]{callback.getRequestedBindType(), callback.getBindingData() == null ? "null" : Base64.encode(callback.getBindingData()), this.session});
        }
    }

    protected void handleNameCallback(NameCallback nc) throws IOException {
        String user_name = nc.getDefaultName();
        this.jid = BareJID.bareJIDInstanceNS(user_name, this.domain);
        nc.setName(this.jid.toString());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "NameCallback: {0}", user_name);
        }
    }

    protected void handlePBKDIterationsCallback(PBKDIterationsCallback callback) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "PBKDIterationsCallback: {0}", this.jid);
        }
        callback.setInterations(this.pbkd2Iterations);
    }

    protected void handleSaltCallback(SaltCallback callback) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "SaltCallback: {0}", this.jid);
        }
        callback.setSalt(this.salt);
    }

    protected void handleSaltedPasswordCallbackCallback(SaltedPasswordCallback callback) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "PasswordCallback: {0}", this.jid);
        }
        try {
            String pwd = this.repo.getPassword(this.jid);
            if (pwd == null) {
                callback.setSaltedPassword(new byte[0]);
            } else {
                byte[] saltedPassword = AbstractSaslSCRAM.hi("SHA1", AbstractSaslSCRAM.normalize(pwd), this.salt, this.pbkd2Iterations);
                callback.setSaltedPassword(saltedPassword);
            }
        }
        catch (Exception e) {
            callback.setSaltedPassword(null);
            this.log.log(Level.FINE, "Can't retrieve user password.", e);
        }
    }

    @Override
    public void setAuthRepository(AuthRepository repo) {
        this.repo = repo;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void setSession(XMPPResourceConnection session) {
        this.session = session;
    }
}

