/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Volume;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Throwables;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.TestcontainersConfiguration;

public final class ResourceReaper {
    private static final Logger log = LoggerFactory.getLogger(ResourceReaper.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceReaper.class);
    private static final List<List<Map.Entry<String, String>>> DEATH_NOTE = new ArrayList<List<Map.Entry<String, String>>>();
    private static final RateLimiter RYUK_ACK_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(4, TimeUnit.SECONDS).withConstantThroughput().build();
    private static ResourceReaper instance;
    private final DockerClient dockerClient;
    private Map<String, String> registeredContainers = new ConcurrentHashMap<String, String>();
    private Set<String> registeredNetworks = Sets.newConcurrentHashSet();
    private Set<String> registeredImages = Sets.newConcurrentHashSet();
    private AtomicBoolean hookIsSet = new AtomicBoolean(false);

    private ResourceReaper() {
        this.dockerClient = DockerClientFactory.instance().client();
    }

    @Deprecated
    public static String start(String hostIpAddress, DockerClient client) {
        return ResourceReaper.start(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String start(final DockerClient client) {
        String ryukImage = ImageNameSubstitutor.instance().apply(DockerImageName.parse("testcontainers/ryuk:0.3.1")).asCanonicalNameString();
        DockerClientFactory.instance().checkAndPullImage(client, ryukImage);
        ArrayList<Bind> binds = new ArrayList<Bind>();
        binds.add(new Bind(DockerClientFactory.instance().getRemoteDockerUnixSocketPath(), new Volume("/var/run/docker.sock")));
        final String ryukContainerId = client.createContainerCmd(ryukImage).withHostConfig(new HostConfig().withAutoRemove(true)).withExposedPorts(new ExposedPort(8080)).withPublishAllPorts(true).withName("testcontainers-ryuk-" + DockerClientFactory.SESSION_ID).withLabels(Collections.singletonMap(DockerClientFactory.TESTCONTAINERS_LABEL, "true")).withBinds(binds).withPrivileged(TestcontainersConfiguration.getInstance().isRyukPrivileged()).exec().getId();
        client.startContainerCmd(ryukContainerId).exec();
        final StringBuilder ryukLog = new StringBuilder();
        ResultCallback.Adapter logCallback = client.logContainerCmd(ryukContainerId).withSince(0).withFollowStream(true).withStdOut(true).withStdErr(true).exec(new ResultCallback.Adapter<Frame>(){

            @Override
            public void onNext(Frame frame) {
                ryukLog.append(new String(frame.getPayload(), StandardCharsets.UTF_8));
            }
        });
        ContainerState containerState = new ContainerState(){
            final InspectContainerResponse inspectedContainer;
            {
                this.inspectedContainer = client.inspectContainerCmd(ryukContainerId).exec();
            }

            @Override
            public List<Integer> getExposedPorts() {
                return Stream.of(this.getContainerInfo().getConfig().getExposedPorts()).map(ExposedPort::getPort).collect(Collectors.toList());
            }

            @Override
            public InspectContainerResponse getContainerInfo() {
                return this.inspectedContainer;
            }
        };
        CountDownLatch ryukScheduledLatch = new CountDownLatch(1);
        List<List<Map.Entry<String, String>>> list = DEATH_NOTE;
        synchronized (list) {
            DEATH_NOTE.add(DockerClientFactory.DEFAULT_LABELS.entrySet().stream().map(it -> new AbstractMap.SimpleEntry<String, String>("label", (String)it.getKey() + "=" + (String)it.getValue())).collect(Collectors.toList()));
        }
        String host = containerState.getHost();
        Integer ryukPort = containerState.getFirstMappedPort();
        Thread kiraThread = new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> {
            while (true) {
                RYUK_ACK_RATE_LIMITER.doWhenReady(() -> {
                    int index = 0;
                    try {
                        Socket clientSocket = new Socket();
                        Throwable throwable = null;
                        try {
                            try {
                                clientSocket.connect(new InetSocketAddress(host, (int)ryukPort), 5000);
                                FilterRegistry registry = new FilterRegistry(clientSocket.getInputStream(), clientSocket.getOutputStream());
                                List<List<Map.Entry<String, String>>> list = DEATH_NOTE;
                                synchronized (list) {
                                    while (true) {
                                        if (DEATH_NOTE.size() <= index) {
                                            try {
                                                DEATH_NOTE.wait(1000L);
                                            }
                                            catch (InterruptedException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                        List<Map.Entry<String, String>> filters = DEATH_NOTE.get(index);
                                        boolean isAcknowledged = registry.register(filters);
                                        if (isAcknowledged) {
                                            log.debug("Received 'ACK' from Ryuk");
                                            ryukScheduledLatch.countDown();
                                            ++index;
                                            continue;
                                        }
                                        log.debug("Didn't receive 'ACK' from Ryuk. Will retry to send filters.");
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (clientSocket != null) {
                                if (throwable != null) {
                                    try {
                                        clientSocket.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    clientSocket.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        log.warn("Can not connect to Ryuk at {}:{}", new Object[]{host, ryukPort, e});
                        return;
                    }
                });
            }
        }, "testcontainers-ryuk");
        kiraThread.setDaemon(true);
        kiraThread.start();
        try {
            if (!ryukScheduledLatch.await(TestcontainersConfiguration.getInstance().getRyukTimeout().intValue(), TimeUnit.SECONDS)) {
                log.error("Timed out waiting for Ryuk container to start. Ryuk's logs:\n{}", (Object)ryukLog);
                throw new IllegalStateException(String.format("Could not connect to Ryuk at %s:%s", host, ryukPort));
            }
        }
        finally {
            try {
                logCallback.close();
            }
            catch (IOException iOException) {}
        }
        return ryukContainerId;
    }

    public static synchronized ResourceReaper instance() {
        if (instance == null) {
            instance = new ResourceReaper();
        }
        return instance;
    }

    public synchronized void performCleanup() {
        this.registeredContainers.forEach(this::stopContainer);
        this.registeredNetworks.forEach(this::removeNetwork);
        this.registeredImages.forEach(this::removeImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFilterForCleanup(List<Map.Entry<String, String>> filter) {
        List<List<Map.Entry<String, String>>> list = DEATH_NOTE;
        synchronized (list) {
            DEATH_NOTE.add(filter);
            DEATH_NOTE.notifyAll();
        }
    }

    public void registerContainerForCleanup(String containerId, String imageName) {
        this.setHook();
        this.registeredContainers.put(containerId, imageName);
    }

    public void stopAndRemoveContainer(String containerId) {
        this.stopContainer(containerId, this.registeredContainers.get(containerId));
        this.registeredContainers.remove(containerId);
    }

    public void stopAndRemoveContainer(String containerId, String imageName) {
        this.stopContainer(containerId, imageName);
        this.registeredContainers.remove(containerId);
    }

    private void stopContainer(String containerId, String imageName) {
        boolean running;
        try {
            InspectContainerResponse containerInfo = this.dockerClient.inspectContainerCmd(containerId).exec();
            running = containerInfo.getState() != null && Boolean.TRUE.equals(containerInfo.getState().getRunning());
        }
        catch (NotFoundException e) {
            LOGGER.trace("Was going to stop container but it apparently no longer exists: {}", (Object)containerId);
            return;
        }
        catch (Exception e) {
            LOGGER.trace("Error encountered when checking container for shutdown (ID: {}) - it may not have been stopped, or may already be stopped. Root cause: {}", (Object)containerId, (Object)Throwables.getRootCause(e).getMessage());
            return;
        }
        if (running) {
            try {
                LOGGER.trace("Stopping container: {}", (Object)containerId);
                this.dockerClient.killContainerCmd(containerId).exec();
                LOGGER.trace("Stopped container: {}", (Object)imageName);
            }
            catch (Exception e) {
                LOGGER.trace("Error encountered shutting down container (ID: {}) - it may not have been stopped, or may already be stopped. Root cause: {}", (Object)containerId, (Object)Throwables.getRootCause(e).getMessage());
            }
        }
        try {
            this.dockerClient.inspectContainerCmd(containerId).exec();
        }
        catch (Exception e) {
            LOGGER.trace("Was going to remove container but it apparently no longer exists: {}", (Object)containerId);
            return;
        }
        try {
            LOGGER.trace("Removing container: {}", (Object)containerId);
            this.dockerClient.removeContainerCmd(containerId).withRemoveVolumes(true).withForce(true).exec();
            LOGGER.debug("Removed container and associated volume(s): {}", (Object)imageName);
        }
        catch (Exception e) {
            LOGGER.trace("Error encountered shutting down container (ID: {}) - it may not have been stopped, or may already be stopped. Root cause: {}", (Object)containerId, (Object)Throwables.getRootCause(e).getMessage());
        }
    }

    public void registerNetworkIdForCleanup(String id) {
        this.setHook();
        this.registeredNetworks.add(id);
    }

    @Deprecated
    public void registerNetworkForCleanup(String networkName) {
        try {
            ((List)this.dockerClient.listNetworksCmd().withNameFilter(networkName).exec()).forEach(network -> this.registerNetworkIdForCleanup(network.getId()));
        }
        catch (Exception e) {
            LOGGER.trace("Error encountered when looking up network (name: {})", (Object)networkName);
        }
    }

    public void removeNetworkById(String id) {
        this.removeNetwork(id);
    }

    @Deprecated
    public void removeNetworks(String identifier) {
        this.removeNetworkById(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNetwork(String id) {
        try {
            List networks;
            try {
                networks = (List)this.dockerClient.listNetworksCmd().withIdFilter(id).exec();
            }
            catch (Exception e) {
                LOGGER.trace("Error encountered when looking up network for removal (name: {}) - it may not have been removed", (Object)id);
                this.registeredNetworks.remove(id);
                return;
            }
            for (Network network : networks) {
                try {
                    this.dockerClient.removeNetworkCmd(network.getId()).exec();
                    this.registeredNetworks.remove(network.getId());
                    LOGGER.debug("Removed network: {}", (Object)id);
                }
                catch (Exception e) {
                    LOGGER.trace("Error encountered removing network (name: {}) - it may not have been removed", (Object)network.getName());
                }
            }
        }
        finally {
            this.registeredNetworks.remove(id);
        }
    }

    public void unregisterNetwork(String identifier) {
        this.registeredNetworks.remove(identifier);
    }

    public void unregisterContainer(String identifier) {
        this.registeredContainers.remove(identifier);
    }

    public void registerImageForCleanup(String dockerImageName) {
        this.setHook();
        this.registeredImages.add(dockerImageName);
    }

    private void removeImage(String dockerImageName) {
        LOGGER.trace("Removing image tagged {}", (Object)dockerImageName);
        try {
            this.dockerClient.removeImageCmd(dockerImageName).withForce(true).exec();
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to delete image " + dockerImageName, e);
        }
    }

    private void setHook() {
        if (this.hookIsSet.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, this::performCleanup));
        }
    }

    static class FilterRegistry {
        @VisibleForTesting
        static final String ACKNOWLEDGMENT = "ACK";
        private final BufferedReader in;
        private final OutputStream out;

        FilterRegistry(InputStream ryukInputStream, OutputStream ryukOutputStream) {
            this.in = new BufferedReader(new InputStreamReader(ryukInputStream));
            this.out = ryukOutputStream;
        }

        protected boolean register(List<Map.Entry<String, String>> filters) throws IOException {
            String query = filters.stream().map(it -> {
                try {
                    return URLEncoder.encode((String)it.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)it.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.joining("&"));
            log.debug("Sending '{}' to Ryuk", (Object)query);
            this.out.write(query.getBytes());
            this.out.write(10);
            this.out.flush();
            return FilterRegistry.waitForAcknowledgment(this.in);
        }

        private static boolean waitForAcknowledgment(BufferedReader in) throws IOException {
            String line = in.readLine();
            while (line != null && !ACKNOWLEDGMENT.equalsIgnoreCase(line)) {
                line = in.readLine();
            }
            return ACKNOWLEDGMENT.equalsIgnoreCase(line);
        }
    }
}

