/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import java.io.Closeable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.AuthDelegatingDockerClientConfig;
import org.testcontainers.dockerclient.DockerClientConfigUtils;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.RemoteApiVersion;
import org.testcontainers.shaded.com.github.dockerjava.okhttp.OkDockerHttpClient;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Throwables;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;
import org.testcontainers.utility.TestcontainersConfiguration;

public abstract class DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(DockerClientProviderStrategy.class);
    private final AtomicReference<Object> dockerClient = new AtomicReference();
    private String dockerHostIpAddress;
    private final RateLimiter PING_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(10, TimeUnit.SECONDS).withConstantThroughput().build();
    private static final AtomicBoolean FAIL_FAST_ALWAYS = new AtomicBoolean(false);

    public abstract String getDescription();

    protected boolean isApplicable() {
        return true;
    }

    protected boolean isPersistable() {
        return true;
    }

    protected int getPriority() {
        return 0;
    }

    public abstract TransportConfig getTransportConfig() throws InvalidConfigurationException;

    @Deprecated
    public DockerClient getClient() {
        DockerClient dockerClient = this.getDockerClient();
        try {
            Unreliables.retryUntilSuccess(30, TimeUnit.SECONDS, () -> this.PING_RATE_LIMITER.getWhenReady(() -> {
                log.debug("Pinging docker daemon...");
                dockerClient.pingCmd().exec();
                log.debug("Pinged");
                return true;
            }));
        }
        catch (TimeoutException e) {
            IOUtils.closeQuietly((Closeable)dockerClient);
            throw e;
        }
        return dockerClient;
    }

    public static DockerClientProviderStrategy getFirstValidStrategy(List<DockerClientProviderStrategy> strategies) {
        if (FAIL_FAST_ALWAYS.get()) {
            throw new IllegalStateException("Previous attempts to find a Docker environment failed. Will not retry. Please see logs and check configuration");
        }
        ArrayList configurationFailures = new ArrayList();
        return (DockerClientProviderStrategy)Stream.concat(Stream.of(TestcontainersConfiguration.getInstance().getDockerClientStrategyClassName()).filter(Objects::nonNull).flatMap(it -> {
            try {
                Class<?> strategyClass = Thread.currentThread().getContextClassLoader().loadClass((String)it);
                return Stream.of(strategyClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                log.warn("Can't instantiate a strategy from {} (ClassNotFoundException). This probably means that cached configuration refers to a client provider class that is not available in this version of Testcontainers. Other strategies will be tried instead.", it);
                return Stream.empty();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("Can't instantiate a strategy from {}", it, (Object)e);
                return Stream.empty();
            }
        }).filter(DockerClientProviderStrategy::isPersistable).peek(strategy -> log.info("Loaded {} from ~/.testcontainers.properties, will try it first", (Object)strategy.getClass().getName())), strategies.stream().filter(DockerClientProviderStrategy::isApplicable).sorted(Comparator.comparing(DockerClientProviderStrategy::getPriority).reversed())).flatMap(strategy -> {
            try {
                Info info;
                DockerClient dockerClient = strategy.getDockerClient();
                try {
                    info = Unreliables.retryUntilSuccess(30, TimeUnit.SECONDS, () -> strategy.PING_RATE_LIMITER.getWhenReady(() -> {
                        log.debug("Pinging docker daemon...");
                        return (Info)dockerClient.infoCmd().exec();
                    }));
                }
                catch (TimeoutException e) {
                    IOUtils.closeQuietly((Closeable)dockerClient);
                    throw e;
                }
                log.info("Found Docker environment with {}", (Object)strategy.getDescription());
                log.debug("Transport type: '{}', Docker host: '{}'", (Object)TestcontainersConfiguration.getInstance().getTransportType(), (Object)strategy.getTransportConfig().getDockerHost());
                log.debug("Checking Docker OS type for {}", (Object)strategy.getDescription());
                String osType = info.getOsType();
                if (StringUtils.isBlank(osType)) {
                    log.warn("Could not determine Docker OS type");
                } else if (!osType.equals("linux")) {
                    log.warn("{} is currently not supported", (Object)osType);
                    throw new InvalidConfigurationException(osType + " containers are currently not supported");
                }
                if (strategy.isPersistable()) {
                    TestcontainersConfiguration.getInstance().updateUserConfig("docker.client.strategy", strategy.getClass().getName());
                }
                return Stream.of(strategy);
            }
            catch (Exception | ExceptionInInitializerError | NoClassDefFoundError e) {
                @Nullable String throwableMessage = e.getMessage();
                Throwable rootCause = Throwables.getRootCause(e);
                @Nullable String rootCauseMessage = rootCause.getMessage();
                String failureDescription = throwableMessage != null && throwableMessage.equals(rootCauseMessage) ? String.format("%s: failed with exception %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage) : String.format("%s: failed with exception %s (%s). Root cause %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage, rootCause.getClass().getSimpleName(), rootCauseMessage);
                configurationFailures.add(failureDescription);
                log.debug(failureDescription);
                return Stream.empty();
            }
        }).findAny().orElseThrow(() -> {
            log.error("Could not find a valid Docker environment. Please check configuration. Attempted configurations were:");
            for (String failureMessage : configurationFailures) {
                log.error("    " + failureMessage);
            }
            log.error("As no valid configuration was found, execution cannot continue");
            FAIL_FAST_ALWAYS.set(true);
            return new IllegalStateException("Could not find a valid Docker environment. Please see logs and check configuration");
        });
    }

    public static DockerClient getClientForConfig(TransportConfig transportConfig) {
        DockerHttpClient dockerHttpClient;
        String transportType;
        switch (transportType = TestcontainersConfiguration.getInstance().getTransportType()) {
            case "okhttp": {
                dockerHttpClient = new OkDockerHttpClient.Builder().dockerHost(transportConfig.getDockerHost()).sslConfig(transportConfig.getSslConfig()).build();
                break;
            }
            case "httpclient5": {
                dockerHttpClient = new ZerodepDockerHttpClient.Builder().dockerHost(transportConfig.getDockerHost()).sslConfig(transportConfig.getSslConfig()).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transport type '" + transportType + "'");
            }
        }
        DefaultDockerClientConfig.Builder configBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        if (configBuilder.build().getApiVersion() == RemoteApiVersion.UNKNOWN_VERSION) {
            configBuilder.withApiVersion(RemoteApiVersion.VERSION_1_30);
        }
        return DockerClientImpl.getInstance(new AuthDelegatingDockerClientConfig(configBuilder.withDockerHost(transportConfig.getDockerHost().toString()).build()), dockerHttpClient);
    }

    public synchronized String getDockerHostIpAddress() {
        if (this.dockerHostIpAddress == null) {
            this.dockerHostIpAddress = DockerClientProviderStrategy.resolveDockerHostIpAddress(this.getDockerClient(), this.getTransportConfig().getDockerHost());
        }
        return this.dockerHostIpAddress;
    }

    @VisibleForTesting
    static String resolveDockerHostIpAddress(DockerClient client, URI dockerHost) {
        String hostOverride = System.getenv("TESTCONTAINERS_HOST_OVERRIDE");
        if (!StringUtils.isBlank(hostOverride)) {
            return hostOverride;
        }
        switch (dockerHost.getScheme()) {
            case "http": 
            case "https": 
            case "tcp": {
                return dockerHost.getHost();
            }
            case "unix": 
            case "npipe": {
                if (DockerClientConfigUtils.IN_A_CONTAINER) {
                    return client.inspectNetworkCmd().withNetworkId("bridge").exec().getIpam().getConfig().stream().filter(it -> it.getGateway() != null).findAny().map(Network.Ipam.Config::getGateway).orElseGet(() -> DockerClientConfigUtils.getDefaultGateway().orElse("localhost"));
                }
                return "localhost";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient getDockerClient() {
        Object value = this.dockerClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.dockerClient;
            synchronized (atomicReference) {
                value = this.dockerClient.get();
                if (value == null) {
                    DockerClient actualValue = DockerClientProviderStrategy.getClientForConfig(this.getTransportConfig());
                    value = actualValue == null ? this.dockerClient : actualValue;
                    this.dockerClient.set(value);
                }
            }
        }
        return (DockerClient)(value == this.dockerClient ? null : value);
    }
}

