/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import com.github.dockerjava.api.command.LogContainerCmd;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.WaitingConsumer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;

public class LogMessageWaitStrategy
extends AbstractWaitStrategy {
    private String regEx;
    private int times = 1;

    @Override
    protected void waitUntilReady() {
        WaitingConsumer waitingConsumer = new WaitingConsumer();
        LogContainerCmd cmd = DockerClientFactory.instance().client().logContainerCmd(this.waitStrategyTarget.getContainerId()).withFollowStream(true).withSince(0).withStdOut(true).withStdErr(true);
        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
            callback.addConsumer(OutputFrame.OutputType.STDOUT, waitingConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, waitingConsumer);
            cmd.exec(callback);
            Predicate<OutputFrame> waitPredicate = outputFrame -> outputFrame.getUtf8String().matches("(?s)" + this.regEx);
            try {
                waitingConsumer.waitUntil(waitPredicate, this.startupTimeout.getSeconds(), TimeUnit.SECONDS, this.times);
            }
            catch (TimeoutException e) {
                throw new ContainerLaunchException("Timed out waiting for log output matching '" + this.regEx + "'");
            }
        }
    }

    public LogMessageWaitStrategy withRegEx(String regEx) {
        this.regEx = regEx;
        return this;
    }

    public LogMessageWaitStrategy withTimes(int times) {
        this.times = times;
        return this;
    }
}

