/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.wait.internal.ExternalPortListeningCheck;
import org.testcontainers.containers.wait.internal.InternalCommandPortListeningCheck;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;

public class HostPortWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(HostPortWaitStrategy.class);

    @Override
    protected void waitUntilReady() {
        Set<Integer> externalLivenessCheckPorts = this.getLivenessCheckPorts();
        if (externalLivenessCheckPorts.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Liveness check ports of {} is empty. Not waiting.", (Object)this.waitStrategyTarget.getContainerInfo().getName());
            }
            return;
        }
        List<Integer> exposedPorts = this.waitStrategyTarget.getExposedPorts();
        Set<Integer> internalPorts = this.getInternalPorts(externalLivenessCheckPorts, exposedPorts);
        InternalCommandPortListeningCheck internalCheck = new InternalCommandPortListeningCheck(this.waitStrategyTarget, internalPorts);
        ExternalPortListeningCheck externalCheck = new ExternalPortListeningCheck(this.waitStrategyTarget, externalLivenessCheckPorts);
        try {
            Unreliables.retryUntilTrue((int)this.startupTimeout.getSeconds(), TimeUnit.SECONDS, () -> this.getRateLimiter().getWhenReady(() -> (Boolean)internalCheck.call() != false && (Boolean)externalCheck.call() != false));
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for container port to open (" + this.waitStrategyTarget.getHost() + " ports: " + externalLivenessCheckPorts + " should be listening)");
        }
    }

    private Set<Integer> getInternalPorts(Set<Integer> externalLivenessCheckPorts, List<Integer> exposedPorts) {
        return exposedPorts.stream().filter(it -> externalLivenessCheckPorts.contains(this.waitStrategyTarget.getMappedPort((int)it))).collect(Collectors.toSet());
    }
}

