/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.utility.TestEnvironment;

public final class ExecInContainerPattern {
    private static final Logger log = LoggerFactory.getLogger(ExecInContainerPattern.class);

    public static Container.ExecResult execInContainer(InspectContainerResponse containerInfo, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(containerInfo, Charset.forName("UTF-8"), command);
    }

    public static Container.ExecResult execInContainer(InspectContainerResponse containerInfo, Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        if (!TestEnvironment.dockerExecutionDriverSupportsExec()) {
            throw new UnsupportedOperationException("Your docker daemon is running the \"lxc\" driver, which doesn't support \"docker exec\".");
        }
        if (!ExecInContainerPattern.isRunning(containerInfo)) {
            throw new IllegalStateException("execInContainer can only be used while the Container is running");
        }
        String containerId = containerInfo.getId();
        String containerName = containerInfo.getName();
        DockerClient dockerClient = DockerClientFactory.instance().client();
        log.debug("{}: Running \"exec\" command: {}", (Object)containerName, (Object)String.join((CharSequence)" ", command));
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withAttachStdout(true).withAttachStderr(true).withCmd(command).exec();
        ToStringConsumer stdoutConsumer = new ToStringConsumer();
        ToStringConsumer stderrConsumer = new ToStringConsumer();
        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
            callback.addConsumer(OutputFrame.OutputType.STDOUT, stdoutConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, stderrConsumer);
            dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec(callback).awaitCompletion();
        }
        Integer exitCode = dockerClient.inspectExecCmd(execCreateCmdResponse.getId()).exec().getExitCode();
        Container.ExecResult result = new Container.ExecResult(exitCode, stdoutConsumer.toString(outputCharset), stderrConsumer.toString(outputCharset));
        log.trace("{}: stdout: {}", (Object)containerName, (Object)result.getStdout());
        log.trace("{}: stderr: {}", (Object)containerName, (Object)result.getStderr());
        return result;
    }

    private static boolean isRunning(InspectContainerResponse containerInfo) {
        try {
            return containerInfo != null && containerInfo.getState().getRunning() != false;
        }
        catch (DockerException e) {
            return false;
        }
    }

    private ExecInContainerPattern() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

