/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.api.model.Volume;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DelegatingDockerClient;
import org.testcontainers.LazyDockerClient;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.images.TimeLimitedLoggedPullImageResultCallback;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;
import org.testcontainers.shaded.org.apache.commons.lang.SystemUtils;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.ResourceReaper;
import org.testcontainers.utility.TestcontainersConfiguration;

public class DockerClientFactory {
    private static final Logger log = LoggerFactory.getLogger(DockerClientFactory.class);
    private final Object $lock = new Object[0];
    public static final ThreadGroup TESTCONTAINERS_THREAD_GROUP = new ThreadGroup("testcontainers");
    public static final String TESTCONTAINERS_LABEL = DockerClientFactory.class.getPackage().getName();
    public static final String TESTCONTAINERS_SESSION_ID_LABEL = TESTCONTAINERS_LABEL + ".sessionId";
    public static final String SESSION_ID = UUID.randomUUID().toString();
    public static final Map<String, String> DEFAULT_LABELS = ImmutableMap.of(TESTCONTAINERS_LABEL, "true", TESTCONTAINERS_SESSION_ID_LABEL, SESSION_ID);
    private static final DockerImageName TINY_IMAGE = DockerImageName.parse("alpine:3.5");
    private static DockerClientFactory instance;
    @VisibleForTesting
    DockerClientProviderStrategy strategy;
    @VisibleForTesting
    DockerClient dockerClient;
    @VisibleForTesting
    RuntimeException cachedClientFailure;
    private String activeApiVersion;
    private String activeExecutionDriver;
    private final AtomicReference<Object> fileMountingSupported = new AtomicReference();

    @VisibleForTesting
    DockerClientFactory() {
    }

    public static DockerClient lazyClient() {
        return LazyDockerClient.INSTANCE;
    }

    public static synchronized DockerClientFactory instance() {
        if (instance == null) {
            instance = new DockerClientFactory();
        }
        return instance;
    }

    public synchronized boolean isDockerAvailable() {
        try {
            this.client();
            return true;
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockerClientProviderStrategy getOrInitializeStrategy() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.strategy != null) {
                return this.strategy;
            }
            ArrayList<DockerClientProviderStrategy> configurationStrategies = new ArrayList<DockerClientProviderStrategy>();
            ServiceLoader.load(DockerClientProviderStrategy.class).forEach(configurationStrategies::add);
            this.strategy = DockerClientProviderStrategy.getFirstValidStrategy(configurationStrategies);
            return this.strategy;
        }
    }

    public TransportConfig getTransportConfig() {
        return this.getOrInitializeStrategy().getTransportConfig();
    }

    public String getRemoteDockerUnixSocketPath() {
        String dockerSocketOverride = System.getenv("TESTCONTAINERS_DOCKER_SOCKET_OVERRIDE");
        if (!StringUtils.isBlank(dockerSocketOverride)) {
            return dockerSocketOverride;
        }
        URI dockerHost = this.getTransportConfig().getDockerHost();
        String path = "unix".equals(dockerHost.getScheme()) ? dockerHost.getRawPath() : "/var/run/docker.sock";
        return SystemUtils.IS_OS_WINDOWS ? "/" + path : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient client() {
        Object object = this.$lock;
        synchronized (object) {
            boolean checksEnabled;
            String ryukContainerId;
            boolean useRyuk;
            if (this.dockerClient != null) {
                return this.dockerClient;
            }
            if (this.cachedClientFailure != null) {
                log.debug("There is a cached checks failure - throwing", (Throwable)this.cachedClientFailure);
                throw this.cachedClientFailure;
            }
            DockerClientProviderStrategy strategy = this.getOrInitializeStrategy();
            log.info("Docker host IP address is {}", (Object)strategy.getDockerHostIpAddress());
            DelegatingDockerClient client = new DelegatingDockerClient(strategy.getDockerClient()){

                @Override
                public void close() {
                    throw new IllegalStateException("You should never close the global DockerClient!");
                }
            };
            Info dockerInfo = (Info)client.infoCmd().exec();
            Version version = (Version)client.versionCmd().exec();
            this.activeApiVersion = version.getApiVersion();
            this.activeExecutionDriver = dockerInfo.getExecutionDriver();
            log.info("Connected to docker: \n  Server Version: " + dockerInfo.getServerVersion() + "\n  API Version: " + this.activeApiVersion + "\n  Operating System: " + dockerInfo.getOperatingSystem() + "\n  Total Memory: " + dockerInfo.getMemTotal() / 0x100000L + " MB");
            boolean bl = useRyuk = !Boolean.parseBoolean(System.getenv("TESTCONTAINERS_RYUK_DISABLED"));
            if (useRyuk) {
                log.debug("Ryuk is enabled");
                try {
                    ryukContainerId = ResourceReaper.start(client);
                }
                catch (RuntimeException e) {
                    this.cachedClientFailure = e;
                    throw e;
                }
                log.info("Ryuk started - will monitor and terminate Testcontainers containers on JVM exit");
            } else {
                log.debug("Ryuk is disabled");
                ryukContainerId = null;
            }
            boolean bl2 = checksEnabled = !TestcontainersConfiguration.getInstance().isDisableChecks();
            if (checksEnabled) {
                log.debug("Checks are enabled");
                try {
                    log.info("Checking the system...");
                    this.checkDockerVersion(version.getVersion());
                    if (ryukContainerId != null) {
                        this.checkDiskSpace(client, ryukContainerId);
                    }
                    this.runInsideDocker(client, createContainerCmd -> {
                        createContainerCmd.withName("testcontainers-checks-" + SESSION_ID);
                        createContainerCmd.getHostConfig().withAutoRemove(true);
                        createContainerCmd.withCmd("tail", "-f", "/dev/null");
                    }, (__, containerId) -> {
                        this.checkDiskSpace(client, (String)containerId);
                        return "";
                    });
                }
                catch (RuntimeException e) {
                    this.cachedClientFailure = e;
                    throw e;
                }
            } else {
                log.debug("Checks are disabled");
            }
            this.dockerClient = client;
            return this.dockerClient;
        }
    }

    private void checkDockerVersion(String dockerVersion) {
        boolean versionIsSufficient = new ComparableVersion(dockerVersion).compareTo(new ComparableVersion("1.6.0")) >= 0;
        this.check("Docker server version should be at least 1.6.0", versionIsSufficient);
    }

    private void checkDiskSpace(DockerClient dockerClient, String id) {
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            dockerClient.execStartCmd(((ExecCreateCmdResponse)dockerClient.execCreateCmd(id).withAttachStdout(true).withCmd("df", "-P").exec()).getId()).exec(new ResultCallback.Adapter<Frame>(){

                @Override
                public void onNext(Frame frame) {
                    if (frame == null) {
                        return;
                    }
                    switch (frame.getStreamType()) {
                        case RAW: 
                        case STDOUT: {
                            try {
                                outputStream.write(frame.getPayload());
                                outputStream.flush();
                                break;
                            }
                            catch (IOException e) {
                                this.onError(e);
                            }
                        }
                    }
                }
            }).awaitCompletion();
        }
        catch (Exception e) {
            log.debug("Can't exec disk checking command", (Throwable)e);
        }
        DiskSpaceUsage df = this.parseAvailableDiskSpace(outputStream.toString());
        this.check("Docker environment should have more than 2GB free disk space", df.availableMB.map(it -> it >= 2048L).orElse(true));
    }

    private void check(String message, boolean isSuccessful) {
        if (!isSuccessful) {
            log.error("\u274c {}", (Object)message);
            throw new IllegalStateException("Check failed: " + message);
        }
        log.info("\u2714\ufe0e {}", (Object)message);
    }

    private boolean checkMountableFile() {
        DockerClient dockerClient = this.client();
        MountableFile mountableFile = MountableFile.forClasspathResource(ResourceReaper.class.getName().replace(".", "/") + ".class");
        Volume volume = new Volume("/dummy");
        try {
            return this.runInsideDocker(createContainerCmd -> createContainerCmd.withBinds(new Bind(mountableFile.getResolvedPath(), volume, AccessMode.ro)), (__, containerId) -> {
                try (InputStream stream = dockerClient.copyArchiveFromContainerCmd((String)containerId, volume.getPath()).exec();){
                    stream.read();
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
        catch (Exception e) {
            log.debug("Failure while checking for mountable file support", (Throwable)e);
            return false;
        }
    }

    public void checkAndPullImage(DockerClient client, String image) {
        try {
            client.inspectImageCmd(image).exec();
        }
        catch (NotFoundException e) {
            client.pullImageCmd(image).exec(new TimeLimitedLoggedPullImageResultCallback(log)).awaitCompletion();
        }
    }

    public String dockerHostIpAddress() {
        return this.getOrInitializeStrategy().getDockerHostIpAddress();
    }

    public <T> T runInsideDocker(Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        return this.runInsideDocker(this.getOrInitializeStrategy().getDockerClient(), createContainerCmdConsumer, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runInsideDocker(DockerClient client, Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        String tinyImage = ImageNameSubstitutor.instance().apply(TINY_IMAGE).asCanonicalNameString();
        this.checkAndPullImage(client, tinyImage);
        CreateContainerCmd createContainerCmd = client.createContainerCmd(tinyImage).withLabels(DEFAULT_LABELS);
        createContainerCmdConsumer.accept(createContainerCmd);
        String id = createContainerCmd.exec().getId();
        try {
            client.startContainerCmd(id).exec();
            T t = block.apply(client, id);
            return t;
        }
        finally {
            try {
                client.removeContainerCmd(id).withRemoveVolumes(true).withForce(true).exec();
            }
            catch (InternalServerErrorException | NotFoundException e) {
                log.debug("Swallowed exception while removing container", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    DiskSpaceUsage parseAvailableDiskSpace(String dfOutput) {
        String[] lines;
        DiskSpaceUsage df = new DiskSpaceUsage();
        for (String line : lines = dfOutput.split("\n")) {
            String[] fields = line.split("\\s+");
            if (fields.length <= 5 || !fields[5].equals("/")) continue;
            long availableKB = Long.parseLong(fields[3]);
            df.availableMB = Optional.of(availableKB / 1024L);
            df.usedPercent = Optional.of(Integer.valueOf(fields[4].replace("%", "")));
            break;
        }
        return df;
    }

    public String getActiveApiVersion() {
        this.client();
        return this.activeApiVersion;
    }

    public String getActiveExecutionDriver() {
        this.client();
        return this.activeExecutionDriver;
    }

    public boolean isUsing(Class<? extends DockerClientProviderStrategy> providerStrategyClass) {
        return this.strategy != null && providerStrategyClass.isAssignableFrom(this.strategy.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileMountingSupported() {
        Object value = this.fileMountingSupported.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.fileMountingSupported;
            synchronized (atomicReference) {
                value = this.fileMountingSupported.get();
                if (value == null) {
                    boolean actualValue = this.checkMountableFile();
                    value = actualValue;
                    this.fileMountingSupported.set(value);
                }
            }
        }
        return (Boolean)value;
    }

    static {
        System.setProperty("org.testcontainers.shaded.io.netty.packagePrefix", "org.testcontainers.shaded.");
    }

    @VisibleForTesting
    static class DiskSpaceUsage {
        Optional<Long> availableMB = Optional.empty();
        Optional<Integer> usedPercent = Optional.empty();

        DiskSpaceUsage() {
        }
    }
}

