/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ansi;

import org.rnorth.ansi.CapabilityDetection;

public class AnsiLite {
    static final String RESET = "\u001b[0m";
    static final String HIGH_INTENSITY = "\u001b[1m";
    static final String LOW_INTENSITY = "\u001b[2m";
    static final String REVERSE_VIDEO = "\u001b[7m";
    static final String UNDERLINE = "\u001b[4m";
    static final String BLACK = "\u001b[30m";
    static final String RED = "\u001b[31m";
    static final String GREEN = "\u001b[32m";
    static final String YELLOW = "\u001b[33m";
    static final String BLUE = "\u001b[34m";
    static final String MAGENTA = "\u001b[35m";
    static final String CYAN = "\u001b[36m";
    static final String WHITE = "\u001b[37m";
    static final String BACKGROUND_BLACK = "\u001b[40m";
    static final String BACKGROUND_RED = "\u001b[41m";
    static final String BACKGROUND_GREEN = "\u001b[42m";
    static final String BACKGROUND_YELLOW = "\u001b[43m";
    static final String BACKGROUND_BLUE = "\u001b[44m";
    static final String BACKGROUND_MAGENTA = "\u001b[45m";
    static final String BACKGROUND_CYAN = "\u001b[46m";
    static final String BACKGROUND_WHITE = "\u001b[47m";
    private final String code;
    private final Object[] s;

    private AnsiLite(String code, Object ... s) {
        this.code = code;
        this.s = s;
    }

    public static AnsiLite underline(Object ... s) {
        return new AnsiLite(UNDERLINE, s);
    }

    public static AnsiLite black(Object ... s) {
        return new AnsiLite(BLACK, s);
    }

    public static AnsiLite red(Object ... s) {
        return new AnsiLite(RED, s);
    }

    public static AnsiLite green(Object ... s) {
        return new AnsiLite(GREEN, s);
    }

    public static AnsiLite yellow(Object ... s) {
        return new AnsiLite(YELLOW, s);
    }

    public static AnsiLite blue(Object ... s) {
        return new AnsiLite(BLUE, s);
    }

    public static AnsiLite magenta(Object ... s) {
        return new AnsiLite(MAGENTA, s);
    }

    public static AnsiLite cyan(Object ... s) {
        return new AnsiLite(CYAN, s);
    }

    public static AnsiLite white(Object ... s) {
        return new AnsiLite(WHITE, s);
    }

    public static AnsiLite bgBlack(Object ... s) {
        return new AnsiLite(BACKGROUND_BLACK, s);
    }

    public static AnsiLite bgRed(Object ... s) {
        return new AnsiLite(BACKGROUND_RED, s);
    }

    public static AnsiLite bgGreen(Object ... s) {
        return new AnsiLite(BACKGROUND_GREEN, s);
    }

    public static AnsiLite bgYellow(Object ... s) {
        return new AnsiLite(BACKGROUND_YELLOW, s);
    }

    public static AnsiLite bgBlue(Object ... s) {
        return new AnsiLite(BACKGROUND_BLUE, s);
    }

    public static AnsiLite bgMagenta(Object ... s) {
        return new AnsiLite(BACKGROUND_MAGENTA, s);
    }

    public static AnsiLite bgCyan(Object ... s) {
        return new AnsiLite(BACKGROUND_CYAN, s);
    }

    public static AnsiLite bgWhite(Object ... s) {
        return new AnsiLite(BACKGROUND_WHITE, s);
    }

    public static AnsiLite bright(Object ... s) {
        return new AnsiLite(HIGH_INTENSITY, s);
    }

    public static AnsiLite dim(Object ... s) {
        return new AnsiLite(LOW_INTENSITY, s);
    }

    public static AnsiLite reverse(Object ... s) {
        return new AnsiLite(REVERSE_VIDEO, s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Object o : this.s) {
            if (this.isEnabled()) {
                sb.append(this.code);
                sb.append(o);
                sb.append(RESET);
                continue;
            }
            sb.append(o);
        }
        return sb.toString();
    }

    private boolean isEnabled() {
        if (System.getProperty("visibleassertions.ansi.enabled") != null) {
            return Boolean.getBoolean("visibleassertions.ansi.enabled");
        }
        if (Boolean.getBoolean("jansi.strip")) {
            return false;
        }
        if (Boolean.getBoolean("jansi.passthrough")) {
            return true;
        }
        if (Boolean.getBoolean("ansi.passthrough")) {
            return true;
        }
        if (Boolean.getBoolean("jansi.force")) {
            return true;
        }
        return CapabilityDetection.isUnderIDEA() || CapabilityDetection.isUnderMaven() || CapabilityDetection.isTty();
    }
}

