/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.login.services;

import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadDomainsSettingService {
    private static final Logger logger = LoggerFactory.getLogger(ReadDomainsSettingService.class);
    private String filepath;
    private List<Map<String, String>> domainSettings = new ArrayList<Map<String, String>>();

    public static ReadDomainsSettingService getInstance() {
        return InstanceLoader.INSTANCE;
    }

    private ReadDomainsSettingService(String string) {
        this.filepath = string;
    }

    public static ReadDomainsSettingService build(String string) {
        if (Strings.isNullOrEmpty((String)ReadDomainsSettingService.getInstance().filepath)) {
            ReadDomainsSettingService.getInstance().filepath = string;
        }
        return ReadDomainsSettingService.getInstance();
    }

    public void sync() throws Exception {
        this.readDefaultDomain();
    }

    private void readDefaultDomain() {
        if (this.filepath == null) {
            logger.error("Cannot read 'domains-settings' file because path is null");
            return;
        }
        this.domainSettings.clear();
        try {
            List<String> list = Files.readAllLines(Paths.get(this.filepath, new String[0]));
            list.forEach(string -> {
                String[] stringArray = string.split(":");
                this.domainSettings.add(Stream.of(new AbstractMap.SimpleEntry<String, String>("domainUid", stringArray[0]), new AbstractMap.SimpleEntry<String, String>("externalUrl", stringArray[1]), new AbstractMap.SimpleEntry<String, String>("defaultDomain", stringArray[2]), new AbstractMap.SimpleEntry<String, String>("otherUrls", stringArray[3])).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            });
        }
        catch (Exception exception) {
            logger.warn("Error occurs trying to read " + this.filepath + " file", (Throwable)exception);
        }
    }

    public Optional<String> getDefaultDomain(String string) {
        if (this.domainSettings == null || this.domainSettings.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> optional = Optional.ofNullable(this.domainSettings.stream().filter(map -> map.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equals("externalUrl") && ((String)entry.getValue()).equals(string))).map(map -> (String)map.get("defaultDomain")).findFirst().map(Strings::emptyToNull).orElse(null));
        return optional;
    }

    /* synthetic */ ReadDomainsSettingService(String string, ReadDomainsSettingService readDomainsSettingService) {
        this(string);
    }

    private static class InstanceLoader {
        private static final ReadDomainsSettingService INSTANCE = new ReadDomainsSettingService(null, null);

        private InstanceLoader() {
        }
    }
}

