/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.login;

import freemarker.template.Configuration;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.handlers.AbstractIndexHandler;
import net.bluemind.webmodules.login.CSRFTokenManager;
import net.bluemind.webmodules.login.LoginHandler;
import net.bluemind.webmodules.login.MessageResolverMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePasswordHandler
extends AbstractIndexHandler
implements NeedVertx {
    private static final Logger logger = LoggerFactory.getLogger(UpdatePasswordHandler.class);
    static Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    static {
        cfg.setClassForTemplateLoading(LoginHandler.class, "/templates");
        cfg.setTagSyntax(0);
    }

    protected String getTemplateName() {
        return "updatepassword.xml";
    }

    protected void loadPageModel(HttpServerRequest httpServerRequest, Map<String, Object> map) {
        super.loadPageModel(httpServerRequest, map);
        String string = CSRFTokenManager.INSTANCE.initRequest(httpServerRequest);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("OSGI-INF/l10n/bundle", new Locale(this.getLang(httpServerRequest)));
        map.put("csrfToken", string);
        map.put("storedRequestId", "x");
        String string2 = httpServerRequest.params().get("userLogin");
        if (string2 == null) {
            string2 = "";
        }
        map.put("userLogin", string2);
        this.manageErrorMsg(httpServerRequest, map, resourceBundle);
        map.put("msg", new MessageResolverMethod(resourceBundle, new Locale(this.getLang(httpServerRequest))));
        logger.debug("display login page with model {}", map);
    }

    private void manageErrorMsg(HttpServerRequest httpServerRequest, Map<String, Object> map, ResourceBundle resourceBundle) {
        logger.info("REQUEST: errors {}", (Object)httpServerRequest.uri());
        MsgErrorCode msgErrorCode = MsgErrorCode.unknown;
        try {
            msgErrorCode = MsgErrorCode.valueOf(httpServerRequest.params().get("authErrorCode"));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            map.put("authErrorMsg", httpServerRequest.params().get("authErrorCode"));
            return;
        }
        logger.info("REQUEST: {} {}", (Object)msgErrorCode);
        map.put("authErrorMsg", resourceBundle.getString(String.format("updatePassword.%s", msgErrorCode.name())));
    }

    protected String getLang(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("Accept-Language");
        if (string != null && string.startsWith("fr")) {
            return "fr";
        }
        return "en";
    }

    public void setModule(WebModule webModule) {
        super.setModule(webModule);
    }

    public void setVertx(Vertx vertx) {
    }

    public static enum MsgErrorCode {
        unknown,
        invalidParameter,
        nullpassword,
        passwordnotmatch,
        usernotfound,
        invalidpassword,
        invalidnewpassword,
        emptyNewPassword,
        invalidCharacterNewPassword,
        mustNotTheSame;

    }
}

