/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.leftpanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.cti.api.Status;
import net.bluemind.cti.api.gwt.endpoint.ComputerTelephonyIntegrationGwtEndpoint;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.Photo;
import net.bluemind.ui.im.client.RosterItemCache;
import net.bluemind.ui.im.client.leftpanel.Entry;
import net.bluemind.ui.im.client.leftpanel.PromptCustomStatus;
import net.bluemind.ui.im.client.leftpanel.RosterItem;
import net.bluemind.ui.im.client.leftpanel.StatusBundle;
import net.bluemind.ui.im.client.leftpanel.StatusStyle;
import net.bluemind.ui.im.client.push.message.PresenceMessage;
import net.bluemind.user.api.gwt.endpoint.UserGwtEndpoint;

public class Header
extends FocusPanel {
    private static HeaderUiBinder uiBinder = (HeaderUiBinder)GWT.create(HeaderUiBinder.class);
    public static HeaderStyle style;
    public static HeaderBundle bundle;
    private static StatusBundle statusBundle;
    private static StatusStyle statusStyle;
    @UiField
    Photo photo;
    @UiField
    SimplePanel statusIM;
    @UiField
    Label statusPhone;
    @UiField
    FlowPanel infos;
    @UiField
    Label displayName;
    @UiField
    MenuBar statusMenu;
    @UiField
    MenuItem statusMenuItem;
    @UiField
    FlowPanel statusContainer;
    private static final int PRIORITY = 1;
    private String imBubbleStyle;

    public Header() {
        this.setWidget((Widget)uiBinder.createAndBindUi((Object)this));
        bundle = (HeaderBundle)GWT.create(HeaderBundle.class);
        style = bundle.getStyle();
        style.ensureInjected();
        statusBundle = (StatusBundle)GWT.create(StatusBundle.class);
        statusStyle = statusBundle.getStyle();
        statusStyle.ensureInjected();
        this.setStyleName(style.header());
        RosterItem rosterItem = new RosterItem();
        rosterItem.name = Ajax.getDisplayName();
        rosterItem.user = Ajax.getDefaultEmail();
        RosterItemCache.getInstance().put(rosterItem.user, rosterItem);
        UserGwtEndpoint userGwtEndpoint = new UserGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{Ajax.TOKEN.getContainerUid()});
        userGwtEndpoint.getPhoto(Ajax.TOKEN.getSubject(), (AsyncHandler)new AsyncHandler<byte[]>(){

            public void success(byte[] byArray) {
                RosterItem rosterItem = new RosterItem();
                rosterItem.name = Ajax.getDisplayName();
                rosterItem.user = Ajax.getDefaultEmail();
                rosterItem.photo = this.atob(new String(byArray));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("data:image/jpeg;base64,");
                stringBuilder.append(rosterItem.photo);
                Header.this.photo.setUrl(stringBuilder.toString());
                RosterItemCache.getInstance().put(rosterItem.user, rosterItem);
            }

            native String atob(String var1);

            public void failure(Throwable throwable) {
            }
        });
        this.photo.setSize(32);
        this.photo.setStyleName(style.photo());
        this.infos.setStyleName(style.infos());
        this.displayName.setText(Ajax.getDisplayName());
        this.displayName.setStyleName(style.displayName());
        this.statusMenuItem.setStyleName(style.statusLabel());
        this.statusContainer.setStyleName(style.statusContainer());
        MenuBar menuBar = new MenuBar(true);
        menuBar.setAutoOpen(false);
        menuBar.setAnimationEnabled(false);
        menuBar.addItem(this.menuItemStyle(statusStyle.statusAvailable(), IMConstants.INST.statusAvailable()), (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                IMCtrl.getInstance().setPresence("available", IMConstants.INST.statusAvailable());
            }
        });
        menuBar.addItem(this.menuItemStyle(statusStyle.statusAvailable(), IMConstants.INST.customStatusMessage()), (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                PromptCustomStatus promptCustomStatus = new PromptCustomStatus(IMConstants.INST.customAvailableStatusMessage(), IMConstants.INST.customMessage(), 1);
                promptCustomStatus.setMode("available");
                promptCustomStatus.show();
            }
        });
        menuBar.addSeparator();
        menuBar.addItem(this.menuItemStyle(statusStyle.statusBusy(), IMConstants.INST.statusBusy()), (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                IMCtrl.getInstance().setPresence("dnd", IMConstants.INST.statusBusy());
            }
        });
        menuBar.addItem(this.menuItemStyle(statusStyle.statusBusy(), IMConstants.INST.customStatusMessage()), (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                PromptCustomStatus promptCustomStatus = new PromptCustomStatus(IMConstants.INST.customBusyStatusMessage(), IMConstants.INST.customMessage(), 1);
                promptCustomStatus.setMode("dnd");
                promptCustomStatus.show();
            }
        });
        menuBar.addSeparator();
        menuBar.addItem(this.menuItemStyle(statusStyle.statusAway(), IMConstants.INST.statusAway()), (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                IMCtrl.getInstance().setPresence("away", IMConstants.INST.statusAway());
            }
        });
        menuBar.addItem(this.menuItemStyle(statusStyle.statusAway(), IMConstants.INST.customStatusMessage()), (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                PromptCustomStatus promptCustomStatus = new PromptCustomStatus(IMConstants.INST.customAwayStatusMessage(), IMConstants.INST.customMessage(), 1);
                promptCustomStatus.setMode("away");
                promptCustomStatus.show();
            }
        });
        this.statusMenuItem.setSubMenu(menuBar);
        this.statusMenu.setStyleName(style.statusDropDownMenu());
        this.statusMenu.addItem(this.statusMenuItem);
        this.imBubbleStyle = statusStyle.status();
        if (Ajax.TOKEN.getRoles().contains("hasCTI")) {
            this.statusPhone.setVisible(true);
            ComputerTelephonyIntegrationGwtEndpoint computerTelephonyIntegrationGwtEndpoint = new ComputerTelephonyIntegrationGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{Ajax.TOKEN.getContainerUid(), Ajax.TOKEN.getSubject()});
            computerTelephonyIntegrationGwtEndpoint.getStatus((AsyncHandler)new AsyncHandler<Status>(){

                public void success(Status status) {
                    Header.this.updatePhoneStatus(Entry.statusFromString(status));
                }

                public void failure(Throwable throwable) {
                    Header.this.setPhoneUnavailable();
                }
            });
        }
        this.setIMAvailable(IMConstants.INST.statusAvailable());
    }

    private SafeHtml menuItemStyle(String string, String string2) {
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        safeHtmlBuilder.appendHtmlConstant("<div class=\"" + style.statusMenuItem() + " " + string + "\">&nbsp;&nbsp;</div> " + string2);
        return safeHtmlBuilder.toSafeHtml();
    }

    private void setIMAvailable(String string) {
        if (string == null || string.isEmpty()) {
            string = IMConstants.INST.statusAvailable();
        }
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusAvailable());
        this.statusMenuItem.setText(string);
    }

    private void setIMBusy(String string) {
        if (string == null || string.isEmpty()) {
            string = IMConstants.INST.statusBusy();
        }
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusBusy());
        this.statusMenuItem.setText(string);
    }

    private void setIMAway(String string) {
        if (string == null || string.isEmpty()) {
            string = IMConstants.INST.statusAway();
        }
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusAway());
        this.statusMenuItem.setText(string);
    }

    private void setPhoneAvailable() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
        this.statusPhone.addStyleName(statusStyle.statusPhoneAvailable());
    }

    private void setPhoneBusy() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
        this.statusPhone.addStyleName(statusStyle.statusPhoneAway());
    }

    private void setPhoneUnavailable() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
        this.statusPhone.addStyleName(statusStyle.statusPhoneOffline());
    }

    private void setPhoneRinging() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
        this.statusPhone.addStyleName(statusStyle.statusPhoneRinging());
    }

    public void updatePhoneStatus(String string) {
        if ("RINGING".equals(string)) {
            this.setPhoneRinging();
        } else if ("BUSY".equals(string) || "CALLING".equals(string)) {
            this.setPhoneBusy();
        } else if ("AVAILABLE".equals(string)) {
            this.setPhoneAvailable();
        } else {
            this.setPhoneUnavailable();
        }
    }

    public void updatePresence(PresenceMessage presenceMessage) {
        String string = presenceMessage.getOwnMode();
        String string2 = presenceMessage.getOwnStatus();
        if ("available".equals(string)) {
            this.setIMAvailable(string2);
        } else if ("dnd".equals(string)) {
            this.setIMBusy(string2);
        } else if ("away".equals(string)) {
            this.setIMAway(string2);
        }
    }

    public static interface HeaderBundle
    extends ClientBundle {
        @ClientBundle.Source(value={"Header.css"})
        public HeaderStyle getStyle();
    }

    public static interface HeaderStyle
    extends CssResource {
        public String header();

        public String photo();

        public String displayName();

        public String infos();

        public String statusLabel();

        public String statusDropDownMenu();

        public String statusMenuItem();

        public String statusContainer();
    }

    static interface HeaderUiBinder
    extends UiBinder<FlowPanel, Header> {
    }
}

