/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.conversation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.RosterItemCache;
import net.bluemind.ui.im.client.chatroom.InviteToChatroom;
import net.bluemind.ui.im.client.chatroom.RoomOccupant;
import net.bluemind.ui.im.client.conversation.Conversation;
import net.bluemind.ui.im.client.leftpanel.RosterItem;
import net.bluemind.ui.im.client.push.Push;

public class MucConversation
extends Conversation {
    private Map<String, RoomOccupant> occupants = new HashMap<String, RoomOccupant>();
    private Map<String, Integer> colors = new HashMap<String, Integer>();

    public MucConversation(final String string) {
        super(string, string);
        this.addParticipant(Ajax.getDefaultEmail());
        Label label = new Label();
        label.setStyleName("fa fa-paper-plane");
        label.setTitle(IMConstants.INST.sendGroupChatHistory());
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                clickEvent.stopPropagation();
                IMCtrl.getInstance().showSendHistoryDialog(string);
            }
        });
        this.toolbar.add((Widget)label);
    }

    @Override
    public void sendMessage(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("message", (JSONValue)new JSONString(string));
        Push.send("xmpp/muc/" + Push.getSidFromPage() + "/" + this.id + ":message", jSONObject);
        this.container.scrollToBottom();
        this.markAllAsRead();
    }

    @Override
    public void addParticipant(String string) {
        RoomOccupant roomOccupant = new RoomOccupant(string);
        if (!this.occupants.containsKey(string)) {
            this.occupants.put(string, roomOccupant);
            if (!this.colors.containsKey(string)) {
                int n = this.colors.size() % 18;
                this.colors.put(string, n);
                roomOccupant.addStyleName("c" + n);
            } else {
                roomOccupant.addStyleName("c" + this.colors.get(string));
            }
            this.roomOccupants.add((Widget)roomOccupant);
            String string2 = string;
            RosterItem rosterItem = (RosterItem)RosterItemCache.getInstance().get(string);
            if (rosterItem != null) {
                string2 = rosterItem.name;
            }
            this.info(IMConstants.INST.hasJoinGroupChat(string2));
        }
    }

    public void removeParticipant(String string) {
        RoomOccupant roomOccupant = this.occupants.get(string);
        this.roomOccupants.remove((Widget)roomOccupant);
        this.occupants.remove(string);
        String string2 = string;
        RosterItem rosterItem = (RosterItem)RosterItemCache.getInstance().get(string);
        if (rosterItem != null) {
            string2 = rosterItem.name;
        }
        this.info(IMConstants.INST.hasLeftGroupChat(string2));
    }

    @Override
    protected void inviteButton() {
        Label label = new Label();
        label.setSize("12px", "12px");
        label.setStyleName("fa fa-lg fa-plus-square-o add-invitee-sign");
        label.setTitle(IMConstants.INST.inviteToGroupChat());
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                InviteToChatroom inviteToChatroom = IMCtrl.getInstance().getInviteToChatroomScreen();
                inviteToChatroom.setRoom(MucConversation.this.id);
                Widget widget = (Widget)clickEvent.getSource();
                int n = widget.getAbsoluteLeft();
                int n2 = widget.getAbsoluteTop() + 24;
                inviteToChatroom.setPopupPosition(n, n2);
                inviteToChatroom.show();
            }
        });
        this.roomOccupants.add((Widget)label);
    }

    @Override
    protected int getColor(String string) {
        return this.colors.get(string);
    }
}

