/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.conversation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SimpleHtmlSanitizer;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import net.bluemind.ui.im.client.MessageFormatter;
import net.bluemind.ui.im.client.Photo;

public class Message
extends Composite {
    private static MessageUiBinder uiBinder = (MessageUiBinder)GWT.create(MessageUiBinder.class);
    public static MessageStyle style;
    public static MessageBundle bundle;
    @UiField
    Photo photo;
    @UiField
    Label from;
    @UiField
    HTMLPanel msgContainer;
    @UiField
    Label date;
    @UiField
    FlowPanel bubble;
    @UiField
    HTMLPanel arrow;
    @UiField
    HTMLPanel arrowOutline;
    @UiField
    HTMLPanel footer;
    private Date timestamp;

    public Message() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        bundle = (MessageBundle)GWT.create(MessageBundle.class);
        style = bundle.getStyle();
        style.ensureInjected();
        this.setStyleName(style.container());
        this.arrow.setStyleName(style.arrow());
        this.arrowOutline.setStyleName(style.arrowOutline());
        this.bubble.setStyleName(style.bubble());
        this.photo.setSize(28);
        this.photo.setStyleName(style.avatar());
        this.footer.setStyleName(style.footer());
        this.from.setStyleName(style.from());
        this.date.setStyleName(style.date());
        this.timestamp = new Date();
    }

    public void setHeaderText(String string) {
        this.from.setText(string);
    }

    public void setDate(String string) {
        this.date.setText(string);
    }

    public void setPicture(String string) {
        this.photo.set(string, 28);
    }

    public void setColor(int n) {
        String string = "c" + n;
        this.photo.addStyleName(string);
        this.from.addStyleName(string);
        this.bubble.addStyleName(string);
        this.arrowOutline.addStyleName("c" + string);
    }

    public void setUnread() {
        this.bubble.addStyleName(style.unread());
        this.arrowOutline.addStyleName(style.arrowOutlineUnread());
        this.arrow.addStyleName(style.arrowUnread());
    }

    public void markAsRead() {
        this.bubble.removeStyleName(style.unread());
        this.arrowOutline.removeStyleName(style.arrowOutlineUnread());
        this.arrow.removeStyleName(style.arrowUnread());
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public void appendMessage(String string) {
        SafeHtml safeHtml = SimpleHtmlSanitizer.sanitizeHtml((String)string);
        HTMLPanel hTMLPanel = new HTMLPanel(MessageFormatter.convert(safeHtml.asString()));
        hTMLPanel.setStyleName(style.msg());
        this.msgContainer.add((Widget)hTMLPanel);
    }

    public void setDownlight() {
        this.bubble.addStyleName(style.downlight());
        this.arrowOutline.addStyleName(style.arrowOutlineDownlight());
        this.arrow.addStyleName(style.arrowDownlight());
    }

    public static interface MessageBundle
    extends ClientBundle {
        @ClientBundle.Source(value={"Message.css"})
        public MessageStyle getStyle();
    }

    public static interface MessageStyle
    extends CssResource {
        public String container();

        public String date();

        public String msg();

        public String unread();

        public String bubble();

        public String avatar();

        public String from();

        public String arrowOutline();

        public String arrow();

        public String arrowOutlineUnread();

        public String arrowUnread();

        public String footer();

        public String downlight();

        public String arrowOutlineDownlight();

        public String arrowDownlight();
    }

    static interface MessageUiBinder
    extends UiBinder<HTMLPanel, Message> {
    }
}

