/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.conversation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.directory.api.BaseDirEntry;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.group.api.Member;
import net.bluemind.group.api.gwt.endpoint.GroupGwtEndpoint;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.IScreen;
import net.bluemind.ui.im.client.chatroom.InviteeSearchBox;
import net.bluemind.ui.im.client.chatroom.InviteeSearchBoxOracle;
import net.bluemind.ui.im.client.chatroom.InviteeSearchSuggestion;
import net.bluemind.ui.im.client.conversation.Invitee;
import net.bluemind.user.api.IUserAsync;
import net.bluemind.user.api.User;
import net.bluemind.user.api.gwt.endpoint.UserGwtEndpoint;

public abstract class InvitationList
extends PopupPanel
implements IScreen {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    public static InvitationListStyle style;
    public static InvitationListBundle bundle;
    protected Map<String, Invitee> invitations;
    private final InviteeSearchBox searchBox;
    @UiField
    protected Button submit;
    @UiField
    protected Button cancel;
    @UiField
    protected FlowPanel form;
    @UiField
    protected FlowPanel footer;

    public InvitationList() {
        this.setWidget((Widget)binder.createAndBindUi(this));
        bundle = (InvitationListBundle)GWT.create(InvitationListBundle.class);
        style = bundle.getStyle();
        style.ensureInjected();
        this.setStyleName(style.invitationList());
        this.setAutoHideEnabled(true);
        this.form.setStyleName(style.form());
        this.footer.setStyleName(style.footer());
        this.invitations = new HashMap<String, Invitee>();
        InviteeSearchBoxOracle inviteeSearchBoxOracle = new InviteeSearchBoxOracle();
        this.searchBox = new InviteeSearchBox(inviteeSearchBoxOracle);
        this.searchBox.addSelectionHandler((SelectionHandler)new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> selectionEvent) {
                DirEntry dirEntry = ((InviteeSearchSuggestion)selectionEvent.getSelectedItem()).getDirectoryEntry();
                if (BaseDirEntry.Kind.USER.equals((Object)dirEntry.kind)) {
                    if (!Ajax.TOKEN.getSubject().equals(dirEntry.entryUid)) {
                        InvitationList.this.addToInvitees(dirEntry.email);
                    }
                } else {
                    InvitationList.this.addGroupToInvitees(dirEntry);
                }
                InvitationList.this.searchBox.setValue(null, false);
                InvitationList.this.searchBox.setFocus(true);
            }
        });
        this.form.add((Widget)this.searchBox);
        this.submit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                InvitationList.this.submit();
            }
        });
        this.cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                InvitationList.this.hide();
            }
        });
    }

    private void addGroupToInvitees(DirEntry dirEntry) {
        GroupGwtEndpoint groupGwtEndpoint = new GroupGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{Ajax.TOKEN.getContainerUid()});
        UserGwtEndpoint userGwtEndpoint = new UserGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{Ajax.TOKEN.getContainerUid()});
        groupGwtEndpoint.getMembers(dirEntry.entryUid, (AsyncHandler)new AsyncHandler<List<Member>>((IUserAsync)userGwtEndpoint){
            private final /* synthetic */ IUserAsync val$userService;
            {
                this.val$userService = iUserAsync;
            }

            public void success(List<Member> list) {
                for (Member member : list) {
                    if (member.type != Member.Type.user) continue;
                    this.val$userService.getComplete(member.uid, (AsyncHandler)new AsyncHandler<ItemValue<User>>(){

                        public void success(ItemValue<User> itemValue) {
                            InvitationList.this.addToInvitees(((User)itemValue.value).defaultEmail().address);
                        }

                        public void failure(Throwable throwable) {
                        }
                    });
                }
            }

            public void failure(Throwable throwable) {
            }
        });
    }

    public abstract void submit();

    public void show() {
        super.show();
        for (String string : this.invitations.keySet()) {
            this.form.remove((Widget)this.invitations.get(string));
        }
        this.invitations = new HashMap<String, Invitee>();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                InvitationList.this.searchBox.setFocus(true);
            }
        });
    }

    public void addToInvitees(final String string) {
        if (!this.invitations.containsKey(string)) {
            final Invitee invitee = new Invitee(string);
            invitee.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    InvitationList.this.form.remove((Widget)invitee);
                    InvitationList.this.invitations.remove(string);
                }
            });
            this.form.insert((Widget)invitee, this.form.getWidgetCount() - 1);
            this.invitations.put(string, invitee);
        }
    }

    protected void setPlaceHolder(String string) {
        this.searchBox.getElement().setAttribute("placeholder", string);
    }

    static interface Binder
    extends UiBinder<Widget, InvitationList> {
    }

    public static interface InvitationListBundle
    extends ClientBundle {
        @ClientBundle.Source(value={"InvitationList.css"})
        public InvitationListStyle getStyle();
    }

    public static interface InvitationListStyle
    extends CssResource {
        public String invitationList();

        public String header();

        public String form();

        public String footer();
    }
}

