/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.conversation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import net.bluemind.ui.common.client.ui.HorizontalTabLayoutPanel;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.IScreen;
import net.bluemind.ui.im.client.RosterItemCache;
import net.bluemind.ui.im.client.conversation.BMMessageEvent;
import net.bluemind.ui.im.client.conversation.Conversation;
import net.bluemind.ui.im.client.conversation.ConversationMessageHandler;
import net.bluemind.ui.im.client.conversation.ConversationTab;
import net.bluemind.ui.im.client.conversation.MarkAsReadEvent;
import net.bluemind.ui.im.client.conversation.ReceiveMessageEvent;
import net.bluemind.ui.im.client.leftpanel.RosterItem;

public class Conversations
extends HorizontalTabLayoutPanel
implements ConversationMessageHandler,
IScreen {
    public static ConversationsStyle style;
    public static ConversationsBundle bundle;
    private HashMap<String, Conversation> conversations;
    private String activeConversation;

    @UiConstructor
    public Conversations(double d, Style.Unit unit) {
        super(d, unit);
        bundle = (ConversationsBundle)GWT.create(ConversationsBundle.class);
        style = bundle.getStyle();
        style.ensureInjected();
        this.addStyleName(style.watermark());
        this.conversations = new HashMap();
        this.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> selectionEvent) {
                final Conversation conversation = (Conversation)Conversations.this.getWidget((Integer)selectionEvent.getSelectedItem());
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        conversation.setFocus();
                        if (Conversations.this.activeConversation != null && !Conversations.this.activeConversation.equals(conversation.getId())) {
                            conversation.markAllAsRead();
                        }
                        Conversations.this.activeConversation = conversation.getId();
                    }
                });
            }
        });
    }

    public void register(final Conversation conversation, boolean bl) {
        Conversation conversation2 = this.conversations.get(conversation.getId());
        if (conversation2 == null) {
            this.conversations.put(conversation.getId(), conversation);
            String string = conversation.getJabberId();
            RosterItem rosterItem = (RosterItem)RosterItemCache.getInstance().get(conversation.getJabberId());
            if (rosterItem != null) {
                string = rosterItem.name;
            }
            ConversationTab conversationTab = new ConversationTab(string);
            ClickHandler clickHandler = new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    clickEvent.preventDefault();
                    IMCtrl.getInstance().unregisterConversation(conversation);
                }
            };
            conversationTab.setCloseBtnAction(clickHandler);
            this.add((Widget)conversation, (Widget)conversationTab);
            conversation2 = conversation;
        }
        if (bl) {
            this.selectTab((Widget)conversation2);
        }
    }

    public void unregister(Conversation conversation) {
        this.conversations.remove(conversation.getId());
        this.remove((Widget)conversation);
    }

    public Conversation getFromId(String string) {
        return this.conversations.get(string);
    }

    @Override
    public void onMessageReceived(ReceiveMessageEvent receiveMessageEvent) {
        BMMessageEvent bMMessageEvent = receiveMessageEvent.getBMMessageEvent();
        Conversation conversation = this.conversations.get(bMMessageEvent.getConvId());
        if (conversation != null) {
            ConversationTab conversationTab = (ConversationTab)this.getTabWidget((Widget)conversation);
            conversationTab.setHighlight();
        }
    }

    @Override
    public void onMarkAsRead(MarkAsReadEvent markAsReadEvent) {
        String string = markAsReadEvent.getJid();
        Conversation conversation = this.conversations.get(string);
        GWT.log((String)("mark as read: " + string));
        if (conversation != null) {
            ConversationTab conversationTab = (ConversationTab)this.getTabWidget((Widget)conversation);
            conversationTab.setDownlight();
        }
    }

    public HashMap<String, Conversation> getConversations() {
        return this.conversations;
    }

    public void setConversations(HashMap<String, Conversation> hashMap) {
        this.conversations = hashMap;
    }

    public String getActiveConversation() {
        return this.activeConversation;
    }

    public void setActiveConversation(String string) {
        this.activeConversation = string;
    }

    public static interface ConversationsBundle
    extends ClientBundle {
        @ClientBundle.Source(value={"Conversations.css"})
        public ConversationsStyle getStyle();
    }

    public static interface ConversationsStyle
    extends CssResource {
        public String watermark();
    }
}

