/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.chatroom;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.IScreen;
import net.bluemind.ui.im.client.RosterItemCache;
import net.bluemind.ui.im.client.leftpanel.RosterItem;
import net.bluemind.ui.im.client.push.message.MucMessage;

public class NewInvitation
extends DialogBox
implements IScreen {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    Label reason;
    @UiField
    Button join;
    @UiField
    Button decline;
    private String room;

    public NewInvitation() {
        this.setWidget((Widget)binder.createAndBindUi(this));
        this.setGlassEnabled(true);
        this.setGlassStyleName("bmOverlay");
        this.setModal(true);
        this.join.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                try {
                    IMCtrl.getInstance().mucAcceptInvitation(NewInvitation.this.room);
                    IMCtrl.getInstance().markAllAsRead();
                }
                catch (Exception exception) {
                    GWT.log((String)exception.getMessage(), (Throwable)exception);
                }
                NewInvitation.this.hide();
            }
        });
        this.decline.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                IMCtrl.getInstance().markAllAsRead();
                NewInvitation.this.hide();
            }
        });
    }

    public void setInvitationEvent(MucMessage mucMessage) {
        this.room = mucMessage.getInvitationRoom();
        String string = mucMessage.getInvitationReason();
        if (string == null || string.trim().isEmpty()) {
            String string2 = mucMessage.getInvitationInviter();
            RosterItem rosterItem = (RosterItem)RosterItemCache.getInstance().get(string2);
            if (rosterItem != null) {
                string2 = rosterItem.name;
            }
            string = IMConstants.INST.hasInvitedYouToGroupChat(string2);
        }
        this.reason.setText(string);
    }

    static interface Binder
    extends UiBinder<Widget, NewInvitation> {
    }
}

