/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.chatroom;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.ui.SuggestOracle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.ListResult;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.directory.api.BaseDirEntry;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.directory.api.DirEntryQuery;
import net.bluemind.directory.api.gwt.endpoint.DirectoryGwtEndpoint;
import net.bluemind.im.api.gwt.endpoint.InstantMessagingGwtEndpoint;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.chatroom.InviteeSearchSuggestion;

public class InviteeSearchBoxOracle
extends SuggestOracle {
    public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
        String string = request.getQuery();
        DirEntryQuery dirEntryQuery = new DirEntryQuery();
        dirEntryQuery.nameOrEmailFilter = string;
        dirEntryQuery.kindsFilter = Arrays.asList(BaseDirEntry.Kind.USER, BaseDirEntry.Kind.GROUP);
        dirEntryQuery.size = 10;
        DirectoryGwtEndpoint directoryGwtEndpoint = new DirectoryGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{Ajax.TOKEN.getContainerUid()});
        directoryGwtEndpoint.search(dirEntryQuery, (AsyncHandler)new AsyncHandler<ListResult<ItemValue<DirEntry>>>(){

            public void success(ListResult<ItemValue<DirEntry>> listResult) {
                ArrayList<InviteeSearchSuggestion> arrayList = new ArrayList<InviteeSearchSuggestion>();
                InviteeSearchBoxOracle.this.validateEntry(listResult.values, arrayList, callback, request);
            }

            public void failure(Throwable throwable) {
                GWT.log((String)throwable.getMessage());
            }
        });
    }

    protected void validateEntry(List<ItemValue<DirEntry>> list, List<InviteeSearchSuggestion> list2, SuggestOracle.Callback callback, SuggestOracle.Request request) {
        ArrayList<CompletionStage> arrayList = new ArrayList<CompletionStage>(list.size());
        int n = 0;
        while (n < list.size()) {
            ItemValue<DirEntry> itemValue = list.get(n);
            if (!((DirEntry)itemValue.value).archived && !((DirEntry)itemValue.value).system) {
                String string = itemValue.uid;
                if (itemValue.uid.contains("/")) {
                    string = itemValue.uid.substring(itemValue.uid.lastIndexOf("/") + 1);
                }
                switch (((DirEntry)itemValue.value).kind) {
                    case USER: {
                        CompletionStage completionStage = ((CompletableFuture)new InstantMessagingGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).promiseApi().isActiveUser(string).thenApply(bl -> {
                            if (bl.booleanValue()) {
                                list2.add(new InviteeSearchSuggestion((DirEntry)itemValue.value));
                            }
                            return null;
                        })).exceptionally(throwable -> {
                            list2.add(new InviteeSearchSuggestion((DirEntry)itemValue.value));
                            return null;
                        });
                        arrayList.add(completionStage);
                        break;
                    }
                    case GROUP: {
                        list2.add(new InviteeSearchSuggestion((DirEntry)itemValue.value));
                        break;
                    }
                    default: {
                        list2.add(new InviteeSearchSuggestion((DirEntry)itemValue.value));
                    }
                }
            }
            ++n;
        }
        ((CompletableFuture)CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0])).thenAccept(void_ -> {
            SuggestOracle.Response response = new SuggestOracle.Response();
            response.setSuggestions((Collection)list2);
            callback.onSuggestionsReady(request, response);
        })).exceptionally(throwable -> {
            SuggestOracle.Response response = new SuggestOracle.Response();
            response.setSuggestions((Collection)list2);
            callback.onSuggestionsReady(request, response);
            return null;
        });
    }
}

