/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.Overlay;
import net.bluemind.ui.im.client.chatroom.InviteToChatroom;
import net.bluemind.ui.im.client.chatroom.NewInvitation;
import net.bluemind.ui.im.client.chatroom.SendHistory;
import net.bluemind.ui.im.client.conversation.Conversation;
import net.bluemind.ui.im.client.conversation.ConversationMessageHandler;
import net.bluemind.ui.im.client.conversation.Conversations;
import net.bluemind.ui.im.client.conversation.CreateConversation;
import net.bluemind.ui.im.client.conversation.MarkAsReadEvent;
import net.bluemind.ui.im.client.conversation.ReceiveMessageEvent;
import net.bluemind.ui.im.client.leftpanel.LeftPanel;
import net.bluemind.ui.im.client.subscription.AddToFavorites;
import net.bluemind.ui.im.client.subscription.RemoveFromFavorites;
import net.bluemind.ui.im.client.subscription.SubscriptionRequest;
import net.bluemind.ui.im.client.viewport.Viewport;

public class RootScreen
extends Composite
implements ConversationMessageHandler {
    private static RootScreenUiBinder uiBinder = (RootScreenUiBinder)GWT.create(RootScreenUiBinder.class);
    private static IMCtrl ctrl;
    private Storage storage;
    @UiField
    LeftPanel leftPanel;
    @UiField
    SimplePanel conversationsContainer;
    private static Timer titleTimer;
    private Conversations conversations;

    public RootScreen() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        ctrl = IMCtrl.getInstance();
        ctrl.registerScreen("leftPanel", this.leftPanel);
        this.conversations = new Conversations(36.0, Style.Unit.PX);
        this.conversationsContainer.add((Widget)this.conversations);
        ctrl.registerScreen("conversations", this.conversations);
        ctrl.registerScreen("createConversation", new CreateConversation());
        ctrl.registerScreen("addToFavorites", new AddToFavorites());
        ctrl.registerScreen("removeFromFavorites", new RemoveFromFavorites());
        ctrl.registerScreen("inviteToChatroom", new InviteToChatroom());
        ctrl.registerScreen("sendHistory", new SendHistory());
        ctrl.registerScreen("subscriptionRequest", new SubscriptionRequest());
        ctrl.registerScreen("newInvitation", new NewInvitation());
        ctrl.registerScreen("overlay", new Overlay());
        ctrl.addMessageReceivedEventHandler(this.conversations);
        ctrl.addMarkAsReadEventHandler(this.conversations);
        ctrl.addMessageReceivedEventHandler(this);
        ctrl.addMarkAsReadEventHandler(this);
        titleTimer = new Timer(){

            public void run() {
                if ("BlueMind IM".equals(Window.getTitle())) {
                    Window.setTitle((String)IMConstants.INST.unreadMessages());
                } else {
                    Window.setTitle((String)"BlueMind IM");
                }
            }
        };
        this.storage = Storage.getLocalStorageIfSupported();
        this.updateViewport();
        Viewport.get().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent focusEvent) {
                RootScreen.this.updateViewport();
            }
        });
        Viewport.get().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent blurEvent) {
                RootScreen.this.updateViewport();
            }
        });
        Window.addCloseHandler((CloseHandler)new CloseHandler<Window>(){

            public void onClose(CloseEvent<Window> closeEvent) {
                IMCtrl.getInstance().leaveMucs();
                RootScreen.this.storage.removeItem("bm-im-focus");
            }
        });
    }

    private void updateViewport() {
        if (Viewport.hasFocus()) {
            this.storage.setItem("bm-im-focus", "true");
        } else {
            this.storage.removeItem("bm-im-focus");
        }
    }

    private static void cancelTitleTimer() {
        titleTimer.cancel();
        Window.setTitle((String)"BlueMind IM");
    }

    @Override
    public void onMessageReceived(ReceiveMessageEvent receiveMessageEvent) {
        titleTimer.cancel();
        titleTimer.scheduleRepeating(750);
    }

    @Override
    public void onMarkAsRead(MarkAsReadEvent markAsReadEvent) {
        HashMap<String, Conversation> hashMap = this.conversations.getConversations();
        int n = 0;
        for (Conversation conversation : hashMap.values()) {
            n += conversation.getUnread().size();
        }
        if (n == 0) {
            RootScreen.cancelTitleTimer();
            IMCtrl.getInstance().markAllAsRead();
        }
    }

    static interface RootScreenUiBinder
    extends UiBinder<DockLayoutPanel, RootScreen> {
    }
}

