/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.MucContext;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class InMemoryMucRepository
implements IMucRepository {
    protected final Map<BareJID, InternalRoom> allRooms = new ConcurrentHashMap<BareJID, InternalRoom>();
    private final MucDAO dao;
    private final RoomConfig.RoomConfigListener roomConfigListener;
    private final Room.RoomListener roomListener;
    protected final Map<BareJID, Room> rooms = new ConcurrentHashMap<BareJID, Room>();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private RoomConfig defaultConfig;
    private MucContext mucConfig;

    public InMemoryMucRepository(MucContext mucConfig, final MucDAO dao) throws RepositoryException {
        this.dao = dao;
        this.mucConfig = mucConfig;
        ArrayList<BareJID> roomJids = dao.getRoomsJIDList();
        if (roomJids != null) {
            for (BareJID jid : roomJids) {
                InternalRoom ir = new InternalRoom();
                ir.isPersistent = true;
                this.addToAllRooms(jid, ir);
            }
        }
        this.roomListener = new Room.RoomListener(){

            @Override
            public void onChangeSubject(Room room, String nick, String newSubject, Date changeDate) {
                try {
                    if (room.getConfig().isPersistentRoom()) {
                        dao.setSubject(room.getRoomJID(), newSubject, nick, changeDate);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void onMessageToOccupants(Room room, JID from, Packet msg) {
            }

            @Override
            public void onSetAffiliation(Room room, BareJID jid, Affiliation newAffiliation) {
                try {
                    if (room.getConfig().isPersistentRoom()) {
                        dao.setAffiliation(room.getRoomJID(), jid, newAffiliation);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.roomConfigListener = new RoomConfig.RoomConfigListener(){

            @Override
            public void onConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
                InMemoryMucRepository.this.roomConfigChanged(roomConfig, modifiedVars);
            }

            @Override
            public void onInitialRoomConfig(RoomConfig roomConfig) {
                try {
                    if (roomConfig.isPersistentRoom()) {
                        Room room = InMemoryMucRepository.this.getRoom(roomConfig.getRoomJID());
                        dao.createRoom(room);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public Room createNewRoom(BareJID roomJID, JID senderJid) throws RepositoryException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating new room '" + roomJID + "'");
        }
        RoomConfig rc = new RoomConfig(roomJID);
        rc.copyFrom(this.getDefaultRoomConfig(), false);
        Room room = Room.newInstance(rc, new Date(), senderJid.getBareJID());
        room.getConfig().addListener(this.roomConfigListener);
        room.addListener(this.roomListener);
        this.rooms.put(roomJID, room);
        InternalRoom ir = new InternalRoom();
        ir.isPersistent = room.getConfig().isPersistentRoom();
        ir.isPublic = room.getConfig().isRoomconfigPublicroom();
        this.addToAllRooms(roomJID, ir);
        return room;
    }

    @Override
    public void destroyRoom(Room room, Element destroyElement) throws RepositoryException {
        BareJID roomJID = room.getRoomJID();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Destroying room '" + roomJID);
        }
        this.rooms.remove(roomJID);
        this.removeFromAllRooms(roomJID);
        this.dao.destroyRoom(roomJID);
        this.fireDestroyRoom(room);
    }

    private void fireDestroyRoom(Room room) {
        Element emptyRoomEvent = new Element("RoomDestroyed", new String[]{"xmlns"}, new String[]{"tigase:events:muc"});
        emptyRoomEvent.addChild((XMLNodeIfc)new Element("room", room.getRoomJID().toString()));
        this.mucConfig.getEventBus().fire(emptyRoomEvent);
    }

    @Override
    public Map<BareJID, Room> getActiveRooms() {
        return Collections.unmodifiableMap(this.rooms);
    }

    @Override
    public RoomConfig getDefaultRoomConfig() throws RepositoryException {
        if (this.defaultConfig == null) {
            this.defaultConfig = new RoomConfig(null);
            try {
                this.defaultConfig.read(this.dao.getRepository(), this.mucConfig, "rooms/default_room_config/config");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, String> getPublicVisibleRooms(String domain) throws RepositoryException {
        HashMap<BareJID, String> result = new HashMap<BareJID, String>();
        for (Map.Entry<BareJID, InternalRoom> entry : this.allRooms.entrySet()) {
            Room room;
            BareJID jid;
            if (entry.getValue().isPublic == null) {
                InternalRoom ir = entry.getValue();
                try {
                    Room room2 = this.dao.readRoom(entry.getKey());
                    InternalRoom internalRoom = ir;
                    synchronized (internalRoom) {
                        ir.isPublic = room2 == null ? false : room2.getConfig().isRoomconfigPublicroom();
                    }
                }
                catch (RepositoryException ex) {
                    entry.getValue().isPublic = false;
                }
            }
            if (!entry.getValue().isPublic.booleanValue() || !domain.equals((jid = entry.getKey()).getDomain())) continue;
            String name = entry.getValue().name;
            if (name == null && (room = this.getRoom(jid)) != null && (name = room.getConfig().getRoomName()) != null && name.isEmpty()) {
                name = null;
            }
            if (name == null) {
                name = jid.getLocalpart();
            }
            result.put(jid, name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BareJID[] getPublicVisibleRoomsIdList() throws RepositoryException {
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        for (Map.Entry<BareJID, InternalRoom> entry : this.allRooms.entrySet()) {
            if (entry.getValue().isPublic == null) {
                InternalRoom ir = entry.getValue();
                try {
                    Room room = this.dao.readRoom(entry.getKey());
                    InternalRoom internalRoom = ir;
                    synchronized (internalRoom) {
                        ir.isPublic = room == null ? false : room.getConfig().isRoomconfigPublicroom();
                    }
                }
                catch (RepositoryException ex) {
                    entry.getValue().isPublic = false;
                }
            }
            if (!entry.getValue().isPublic.booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new BareJID[0]);
    }

    @Override
    public Room getRoom(BareJID roomJID) throws RepositoryException {
        Room room = this.rooms.get(roomJID);
        if (room == null) {
            InternalRoom ir = this.allRooms.get(roomJID);
            if (ir != null) {
                roomJID = ir.roomJid;
            }
            if ((room = this.dao.readRoom(roomJID)) != null) {
                room.getConfig().addListener(this.roomConfigListener);
                room.addListener(this.roomListener);
                this.rooms.put(roomJID, room);
            }
        }
        return room;
    }

    @Override
    public String getRoomName(String jid) throws RepositoryException {
        BareJID roomJID = BareJID.bareJIDInstanceNS((String)jid);
        Room r = this.rooms.get(roomJID);
        if (r != null) {
            return r.getConfig().getRoomName();
        }
        InternalRoom ir = this.allRooms.get(roomJID);
        if (ir != null) {
            roomJID = ir.roomJid;
        }
        return this.dao.getRoomName(roomJID.toString());
    }

    @Override
    public boolean isRoomIdExists(String newRoomName) {
        return this.allRooms.containsKey(BareJID.bareJIDInstanceNS((String)newRoomName));
    }

    @Override
    public void leaveRoom(Room room) {
        BareJID roomJID = room.getRoomJID();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Removing room '" + roomJID + "' from memory");
        }
        this.rooms.remove(roomJID);
        if (!room.getConfig().isPersistentRoom()) {
            this.removeFromAllRooms(roomJID);
        }
        this.fireDestroyRoom(room);
    }

    @Override
    public void updateDefaultRoomConfig(RoomConfig config) throws RepositoryException {
        RoomConfig org = this.getDefaultRoomConfig();
        org.copyFrom(config);
        this.dao.updateRoomConfig(this.defaultConfig);
    }

    protected void addToAllRooms(BareJID roomJid, InternalRoom internalRoom) {
        internalRoom.roomJid = roomJid;
        this.allRooms.put(roomJid, internalRoom);
    }

    protected void removeFromAllRooms(BareJID roomJid) {
        this.allRooms.remove(roomJid);
    }

    protected void roomConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
        try {
            InternalRoom ir;
            if (modifiedVars.contains("muc#roomconfig_publicroom") && (ir = this.allRooms.get(roomConfig.getRoomJID())) != null) {
                ir.isPublic = roomConfig.isRoomconfigPublicroom();
            }
            if (modifiedVars.contains("muc#roomconfig_roomname") && (ir = this.allRooms.get(roomConfig.getRoomJID())) != null) {
                String name = roomConfig.getRoomName();
                if (name != null && name.isEmpty()) {
                    name = null;
                }
                System.out.println("setting room name '" + name + "'");
                ir.name = name;
            }
            if (modifiedVars.contains("muc#roomconfig_persistentroom")) {
                if (roomConfig.isPersistentRoom()) {
                    Room room = this.getRoom(roomConfig.getRoomJID());
                    this.dao.createRoom(room);
                } else {
                    this.dao.destroyRoom(roomConfig.getRoomJID());
                }
                ir = this.allRooms.get(roomConfig.getRoomJID());
                if (ir != null) {
                    ir.isPersistent = roomConfig.isPersistentRoom();
                }
            } else if (roomConfig.isPersistentRoom()) {
                this.dao.updateRoomConfig(roomConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class InternalRoom {
        public Boolean isPublic = null;
        public boolean isPersistent = false;
        public String name;
        private BareJID roomJid;
    }
}

