/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.security.SecureRandom;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MucContext;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;

public class UniqueRoomNameModule
extends AbstractMucModule {
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"unique", (String)"http://jabber.org/protocol/muc#unique"));
    public static final String ID = "unique";
    private SecureRandom random = new SecureRandom();

    private String generateName(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int a = this.random.nextInt(CHARS.length());
            sb.append(CHARS.charAt(a));
        }
        return sb.toString();
    }

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet element) throws MUCException {
        try {
            String newRoomName;
            JID jid = JID.jidInstance((String)element.getAttributeStaticStr("to"));
            if (jid.getResource() != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            String host = jid.getDomain();
            do {
                newRoomName = this.generateName(30);
            } while (((MucContext)this.context).getMucRepository().isRoomIdExists(newRoomName + "@" + host));
            Element unique = new Element(ID, new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#unique"});
            unique.setCData(newRoomName);
            this.write(element.okResult(unique, 0));
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

