/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.DateUtil;
import tigase.muc.MucContext;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.AbstractMucModule;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class GroupchatMessageModule
extends AbstractMucModule {
    public static final String ID = "groupchat";
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"groupchat");
    private static final Criteria CRIT_CHAT_STAT = ElementCriteria.xmlns((String)"http://jabber.org/protocol/chatstates");
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();

    protected void addMessageToHistory(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        block7: {
            block6: {
                try {
                    HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
                    if (historyProvider != null) {
                        historyProvider.addMessage(room, message, body, senderJid, senderNickname, time);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.WARNING)) break block6;
                    this.log.log(Level.WARNING, "Can't add message to history!", e);
                }
            }
            try {
                MucLogger mucLogger = ((MucContext)this.context).getMucLogger();
                if (mucLogger != null && room.getConfig().isLoggingEnabled()) {
                    mucLogger.addMessage(room, body, senderJid, senderNickname, time);
                }
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.WARNING)) break block7;
                this.log.log(Level.WARNING, "Can't add message to log!", e);
            }
        }
    }

    protected void addSubjectChangeToHistory(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
        block7: {
            block6: {
                try {
                    HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
                    if (historyProvider != null) {
                        historyProvider.addSubjectChange(room, message, subject, senderJid, senderNickname, time);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.WARNING)) break block6;
                    this.log.log(Level.WARNING, "Can't add subject change to history!", e);
                }
            }
            try {
                MucLogger mucLogger = ((MucContext)this.context).getMucLogger();
                if (mucLogger != null && room.getConfig().isLoggingEnabled()) {
                    mucLogger.addSubjectChange(room, subject, senderJid, senderNickname, time);
                }
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.WARNING)) break block7;
                this.log.log(Level.WARNING, "Can't add subject change to log!", e);
            }
        }
    }

    public void afterRegistration() {
        super.afterRegistration();
    }

    public String[] getFeatures() {
        ArrayList<String> f = new ArrayList<String>();
        f.add("http://jabber.org/protocol/muc");
        if (this.isChatStateAllowed()) {
            f.add("http://jabber.org/protocol/chatstates");
        }
        return f.toArray(new String[0]);
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isChatStateAllowed() {
        return this.allowedElements.contains(CRIT_CHAT_STAT);
    }

    protected Packet preparePacket(String messageId, String xmlLang, Element ... content) throws TigaseStringprepException {
        Element e = new Element("message", new String[]{"type"}, new String[]{ID});
        if (messageId != null) {
            e.setAttribute("id", messageId);
        }
        if (xmlLang != null) {
            e.setAttribute("xml:lang", xmlLang);
        }
        if (content != null) {
            e.addChildren(Arrays.asList(content));
        }
        Packet message = Packet.packetInstance((Element)e);
        message.setXMLNS("jabber:client");
        return message;
    }

    public void process(Packet packet) throws MUCException {
        try {
            String msg;
            JID senderJID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
            if (GroupchatMessageModule.getNicknameFromJid(JID.jidInstance((String)packet.getAttributeStaticStr("to"))) != null) {
                throw new MUCException(Authorization.BAD_REQUEST, "Groupchat message can't be addressed to occupant.");
            }
            Room room = ((MucContext)this.context).getMucRepository().getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "There is no such room.");
            }
            String nickName = room.getOccupantsNickname(senderJID);
            Role role = room.getRole(nickName);
            Affiliation affiliation = room.getAffiliation(senderJID.getBareJID());
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Processing groupchat message. room=" + roomJID + "; senderJID=" + senderJID + "; senderNickname=" + nickName + "; role=" + (Object)((Object)role) + "; affiliation=" + (Object)((Object)affiliation) + ";");
            }
            if (!role.isSendMessagesToAll() || room.getConfig().isRoomModerated() && role == Role.visitor) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Insufficient privileges to send grouchat message: role=" + (Object)((Object)role) + "; roomModerated=" + room.getConfig().isRoomModerated() + "; stanza=" + packet.getElement().toStringNoChildren());
                }
                throw new MUCException(Authorization.FORBIDDEN, "Insufficient privileges to send groupchat message.");
            }
            String xmlLang = packet.getElement().getAttributeStaticStr("xml:lang");
            Element body = null;
            Element subject = null;
            Element delay = null;
            String id = packet.getAttributeStaticStr("id");
            ArrayList<Element> content = new ArrayList<Element>();
            List ccs = packet.getElement().getChildren();
            if (ccs != null) {
                block4: for (Element c : ccs) {
                    if ("delay".equals(c.getName())) {
                        delay = c;
                        continue;
                    }
                    if ("body".equals(c.getName())) {
                        body = c;
                        content.add(c);
                        continue;
                    }
                    if ("subject".equals(c.getName())) {
                        subject = c;
                        content.add(c);
                        continue;
                    }
                    if (!((MucContext)this.context).isMessageFilterEnabled()) {
                        content.add(c);
                        continue;
                    }
                    if (((MucContext)this.context).isChatStateAllowed() && CRIT_CHAT_STAT.match(c)) {
                        content.add(c);
                        continue;
                    }
                    for (Criteria crit : this.allowedElements) {
                        if (!crit.match(c)) continue;
                        content.add(c);
                        continue block4;
                    }
                }
            }
            JID senderRoomJID = JID.jidInstance((BareJID)roomJID, (String)nickName);
            Date sendDate = delay != null && affiliation == Affiliation.owner ? DateUtil.parse(delay.getAttributeStaticStr("stamp")) : new Date();
            if (subject != null) {
                if (!(room.getConfig().isChangeSubject() && role == Role.participant || role.isModifySubject())) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Insufficient privileges to change subject: role=" + (Object)((Object)role) + "; allowToChangeSubject=" + room.getConfig().isChangeSubject() + "; stanza=" + packet.getElement().toStringNoChildren());
                    }
                    throw new MUCException(Authorization.FORBIDDEN, "Insufficient privileges to change subject.");
                }
                msg = subject.getCData();
                room.setNewSubject(msg, nickName);
                room.setSubjectChangeDate(sendDate);
            }
            if (id == null && ((MucContext)this.context).isAddMessageIdIfMissing()) {
                id = subject != null ? GroupchatMessageModule.generateSubjectId(sendDate, subject == null ? "" : subject.getCData()) : UUID.randomUUID().toString();
            }
            msg = this.preparePacket(id, xmlLang, content.toArray(new Element[0]));
            if (body != null) {
                this.addMessageToHistory(room, msg.getElement(), body.getCData(), senderJID, nickName, sendDate);
            }
            if (subject != null) {
                this.addSubjectChangeToHistory(room, msg.getElement(), subject.getCData(), senderJID, nickName, sendDate);
            }
            this.sendMessagesToAllOccupants(room, senderRoomJID, (Packet)msg);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, Element ... content) throws TigaseStringprepException {
        Packet msg = this.preparePacket(null, null, content);
        this.sendMessagesToAllOccupants(room, fromJID, msg);
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, String xmlLang, Element ... content) throws TigaseStringprepException {
        Packet msg = this.preparePacket(null, xmlLang, content);
        this.sendMessagesToAllOccupants(room, fromJID, msg);
    }

    public static String generateSubjectId(Date ts, String subject) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(String.valueOf(ts.getTime()).getBytes());
            if (subject != null) {
                md.update(subject.getBytes());
            }
            StringBuilder sb = new StringBuilder();
            for (byte b : md.digest()) {
                sb.append(Character.forDigit((b & 0xF0) >> 4, 16));
                sb.append(Character.forDigit(b & 0xF, 16));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, Packet msg) throws TigaseStringprepException {
        this.sendMessagesToAllOccupantsJids(room, fromJID, msg);
        room.fireOnMessageToOccupants(fromJID, msg);
    }

    public void sendMessagesToAllOccupantsJids(Room room, JID fromJID, Packet msg) throws TigaseStringprepException {
        for (String nickname : room.getOccupantsNicknames()) {
            Role role = room.getRole(nickname);
            if (!role.isReceiveMessages()) continue;
            Collection<JID> occupantJids = room.getOccupantsJidsByNickname(nickname);
            for (JID jid : occupantJids) {
                Packet message = msg.copyElementOnly();
                message.initVars(fromJID, jid);
                message.setXMLNS("jabber:client");
                this.write(message);
            }
        }
    }
}

