/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.Date;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.muc.DateUtil;
import tigase.muc.history.HistoryProvider;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class AbstractHistoryProvider
implements HistoryProvider {
    protected static final SimpleParser parser = SingletonFactory.getParserInstance();
    protected final Logger log = Logger.getLogger(this.getClass().getName());

    protected Packet createMessage(BareJID roomJID, JID senderJID, String msgSenderNickname, String originalMessage, String body, String msgSenderJid, boolean addRealJids, Date msgTimestamp) throws TigaseStringprepException {
        Packet message = null;
        if (originalMessage != null) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse((SimpleHandler)domHandler, originalMessage.toCharArray(), 0, originalMessage.length());
            Queue queue = domHandler.getParsedElements();
            Element m = (Element)queue.poll();
            if (m != null) {
                m.setAttribute("type", "groupchat");
                m.setAttribute("from", JID.jidInstance((BareJID)roomJID, (String)msgSenderNickname).toString());
                m.setAttribute("to", senderJID.toString());
                message = Packet.packetInstance((Element)m);
                message.setXMLNS("jabber:client");
            }
        }
        if (message == null) {
            message = Packet.packetInstance((Element)new Element("message", new String[]{"type", "from", "to"}, new String[]{"groupchat", JID.jidInstance((BareJID)roomJID, (String)msgSenderNickname).toString(), senderJID.toString()}));
            message.setXMLNS("jabber:client");
            message.getElement().addChild((XMLNodeIfc)new Element("body", body));
        }
        Element delay = new Element("delay", new String[]{"xmlns", "from", "stamp"}, new String[]{"urn:xmpp:delay", roomJID.toString(), DateUtil.formatDatetime(msgTimestamp)});
        message.getElement().addChild((XMLNodeIfc)delay);
        return message;
    }
}

