/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import tigase.muc.MUCComponent;
import tigase.muc.history.DerbySqlHistoryProvider;
import tigase.muc.history.MemoryHistoryProvider;
import tigase.muc.history.MySqlHistoryProvider;
import tigase.muc.history.NoneHistoryProvider;
import tigase.muc.history.PostgreSqlHistoryProvider;
import tigase.muc.history.SqlserverSqlHistoryProvider;
import tigase.osgi.ModulesManager;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private BundleContext context = null;
    private Class<MUCComponent> mucComponentClass = null;
    private List<Class> repositoryClasses = null;
    private ModulesManager serviceManager = null;
    private ServiceReference serviceReference = null;

    private void registerAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.registerServerComponentClass(this.mucComponentClass);
            for (Class repositoryClass : this.repositoryClasses) {
                this.serviceManager.registerClass(repositoryClass);
            }
            this.serviceManager.update();
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            if (this.serviceReference == null) {
                this.serviceReference = event.getServiceReference();
                this.serviceManager = (ModulesManager)this.context.getService(this.serviceReference);
                this.registerAddons();
            }
        } else if (event.getType() == 4 && this.serviceReference == event.getServiceReference()) {
            this.unregisterAddons();
            this.context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            this.context = bc;
            this.mucComponentClass = MUCComponent.class;
            this.repositoryClasses = new ArrayList<Class>();
            this.repositoryClasses.add(DerbySqlHistoryProvider.class);
            this.repositoryClasses.add(MemoryHistoryProvider.class);
            this.repositoryClasses.add(MySqlHistoryProvider.class);
            this.repositoryClasses.add(NoneHistoryProvider.class);
            this.repositoryClasses.add(PostgreSqlHistoryProvider.class);
            this.repositoryClasses.add(SqlserverSqlHistoryProvider.class);
            bc.addServiceListener((ServiceListener)this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
            this.serviceReference = bc.getServiceReference(ModulesManager.class.getName());
            if (this.serviceReference != null) {
                this.serviceManager = (ModulesManager)bc.getService(this.serviceReference);
                this.registerAddons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            if (this.serviceManager != null) {
                this.unregisterAddons();
                this.context.ungetService(this.serviceReference);
                this.serviceManager = null;
                this.serviceReference = null;
            }
            this.mucComponentClass = null;
            this.repositoryClasses = null;
        }
    }

    private void unregisterAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.unregisterServerComponentClass(this.mucComponentClass);
            for (Class repositoryClass : this.repositoryClasses) {
                this.serviceManager.unregisterClass(repositoryClass);
            }
            this.serviceManager.update();
        }
    }
}

