/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.FullChangeSerde;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.state.internals.BufferValue;
import org.apache.kafka.streams.state.internals.ContextualRecord;

final class TimeOrderedKeyValueBufferChangelogDeserializationHelper {
    private TimeOrderedKeyValueBufferChangelogDeserializationHelper() {
    }

    static DeserializationResult deserializeV0(ConsumerRecord<byte[], byte[]> record, Bytes key, byte[] previousBufferedValue) {
        ByteBuffer timeAndValue = ByteBuffer.wrap(record.value());
        long time = timeAndValue.getLong();
        byte[] changelogValue = new byte[record.value().length - 8];
        timeAndValue.get(changelogValue);
        Change<byte[]> change = Objects.requireNonNull(FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays(changelogValue));
        ProcessorRecordContext recordContext = new ProcessorRecordContext(record.timestamp(), record.offset(), record.partition(), record.topic(), record.headers());
        return new DeserializationResult(time, key, new BufferValue(previousBufferedValue == null ? (byte[])change.oldValue : previousBufferedValue, (byte[])change.oldValue, (byte[])change.newValue, recordContext));
    }

    static DeserializationResult deserializeV1(ConsumerRecord<byte[], byte[]> record, Bytes key, byte[] previousBufferedValue) {
        ByteBuffer timeAndValue = ByteBuffer.wrap(record.value());
        long time = timeAndValue.getLong();
        byte[] changelogValue = new byte[record.value().length - 8];
        timeAndValue.get(changelogValue);
        ContextualRecord contextualRecord = ContextualRecord.deserialize(ByteBuffer.wrap(changelogValue));
        Change<byte[]> change = Objects.requireNonNull(FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays(contextualRecord.value()));
        return new DeserializationResult(time, key, new BufferValue(previousBufferedValue == null ? (byte[])change.oldValue : previousBufferedValue, (byte[])change.oldValue, (byte[])change.newValue, contextualRecord.recordContext()));
    }

    static DeserializationResult duckTypeV2(ConsumerRecord<byte[], byte[]> record, Bytes key) {
        DeserializationResult deserializationResult = null;
        RuntimeException v2DeserializationException = null;
        RuntimeException v3DeserializationException = null;
        try {
            deserializationResult = TimeOrderedKeyValueBufferChangelogDeserializationHelper.deserializeV2(record, key);
        }
        catch (RuntimeException e) {
            v2DeserializationException = e;
        }
        if (deserializationResult == null) {
            try {
                deserializationResult = TimeOrderedKeyValueBufferChangelogDeserializationHelper.deserializeV3(record, key);
            }
            catch (RuntimeException e) {
                v3DeserializationException = e;
            }
        }
        if (deserializationResult == null) {
            RuntimeException exception = new RuntimeException("Couldn't deserialize record as v2 or v3: " + record, v2DeserializationException);
            exception.addSuppressed(v3DeserializationException);
            throw exception;
        }
        return deserializationResult;
    }

    private static DeserializationResult deserializeV2(ConsumerRecord<byte[], byte[]> record, Bytes key) {
        ByteBuffer valueAndTime = ByteBuffer.wrap(record.value());
        ContextualRecord contextualRecord = ContextualRecord.deserialize(valueAndTime);
        Change<byte[]> change = Objects.requireNonNull(FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays(contextualRecord.value()));
        byte[] priorValue = Utils.getNullableSizePrefixedArray(valueAndTime);
        long time = valueAndTime.getLong();
        BufferValue bufferValue = new BufferValue(priorValue, (byte[])change.oldValue, (byte[])change.newValue, contextualRecord.recordContext());
        return new DeserializationResult(time, key, bufferValue);
    }

    static DeserializationResult deserializeV3(ConsumerRecord<byte[], byte[]> record, Bytes key) {
        ByteBuffer valueAndTime = ByteBuffer.wrap(record.value());
        BufferValue bufferValue = BufferValue.deserialize(valueAndTime);
        long time = valueAndTime.getLong();
        return new DeserializationResult(time, key, bufferValue);
    }

    static final class DeserializationResult {
        private final long time;
        private final Bytes key;
        private final BufferValue bufferValue;

        private DeserializationResult(long time, Bytes key, BufferValue bufferValue) {
            this.time = time;
            this.key = key;
            this.bufferValue = bufferValue;
        }

        long time() {
            return this.time;
        }

        Bytes key() {
            return this.key;
        }

        BufferValue bufferValue() {
            return this.bufferValue;
        }
    }
}

