/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerializer;

public class MeteredTimestampedKeyValueStore<K, V>
extends MeteredKeyValueStore<K, ValueAndTimestamp<V>>
implements TimestampedKeyValueStore<K, V> {
    MeteredTimestampedKeyValueStore(KeyValueStore<Bytes, byte[]> inner, String metricScope, Time time, Serde<K> keySerde, Serde<ValueAndTimestamp<V>> valueSerde) {
        super(inner, metricScope, time, keySerde, valueSerde);
    }

    @Override
    protected Serde<ValueAndTimestamp<V>> prepareValueSerdeForStore(Serde<ValueAndTimestamp<V>> valueSerde, SerdeGetter getter) {
        if (valueSerde == null) {
            return new ValueAndTimestampSerde(getter.valueSerde());
        }
        return super.prepareValueSerdeForStore(valueSerde, getter);
    }

    public RawAndDeserializedValue<V> getWithBinary(K key) {
        try {
            return StreamsMetricsImpl.maybeMeasureLatency(() -> {
                byte[] serializedValue = (byte[])((KeyValueStore)this.wrapped()).get(this.keyBytes(key));
                return new RawAndDeserializedValue(serializedValue, (ValueAndTimestamp)this.outerValue(serializedValue));
            }, this.time, this.getSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, e);
        }
    }

    public boolean putIfDifferentValues(K key, ValueAndTimestamp<V> newValue, byte[] oldSerializedValue) {
        try {
            return StreamsMetricsImpl.maybeMeasureLatency(() -> {
                byte[] newSerializedValue = this.serdes.rawValue(newValue);
                if (ValueAndTimestampSerializer.valuesAreSameAndTimeIsIncreasing(oldSerializedValue, newSerializedValue)) {
                    return false;
                }
                ((KeyValueStore)this.wrapped()).put(this.keyBytes(key), newSerializedValue);
                return true;
            }, this.time, this.putSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, newValue);
            throw new ProcessorStateException(message, e);
        }
    }

    static class RawAndDeserializedValue<ValueType> {
        final byte[] serializedValue;
        final ValueAndTimestamp<ValueType> value;

        RawAndDeserializedValue(byte[] serializedValue, ValueAndTimestamp<ValueType> value) {
            this.serializedValue = serializedValue;
            this.value = value;
        }
    }
}

