/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class MeteredKeyValueStore<K, V>
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>, K, V>
implements KeyValueStore<K, V> {
    final Serde<K> keySerde;
    final Serde<V> valueSerde;
    StateSerdes<K, V> serdes;
    private final String metricsScope;
    protected final Time time;
    protected Sensor putSensor;
    private Sensor putIfAbsentSensor;
    protected Sensor getSensor;
    private Sensor deleteSensor;
    private Sensor putAllSensor;
    private Sensor allSensor;
    private Sensor rangeSensor;
    private Sensor prefixScanSensor;
    private Sensor flushSensor;
    private Sensor e2eLatencySensor;
    private InternalProcessorContext context;
    private StreamsMetricsImpl streamsMetrics;
    private TaskId taskId;

    MeteredKeyValueStore(KeyValueStore<Bytes, byte[]> inner, String metricsScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.metricsScope = metricsScope;
        this.time = time != null ? time : Time.SYSTEM;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.taskId = context.taskId();
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.taskId = context.taskId();
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    private void registerMetrics() {
        this.putSensor = StateStoreMetrics.putSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.putIfAbsentSensor = StateStoreMetrics.putIfAbsentSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.putAllSensor = StateStoreMetrics.putAllSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.getSensor = StateStoreMetrics.getSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.allSensor = StateStoreMetrics.allSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.rangeSensor = StateStoreMetrics.rangeSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.prefixScanSensor = StateStoreMetrics.prefixScanSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.flushSensor = StateStoreMetrics.flushSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.deleteSensor = StateStoreMetrics.deleteSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.e2eLatencySensor = StateStoreMetrics.e2ELatencySensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
    }

    protected Serde<V> prepareValueSerdeForStore(Serde<V> valueSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareValueSerde(valueSerde, getter);
    }

    @Deprecated
    private void initStoreSerde(ProcessorContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName);
        this.serdes = new StateSerdes<K, V>(changelogTopic != null ? changelogTopic : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName, this.taskId.topologyName()), WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), this.prepareValueSerdeForStore(this.valueSerde, new SerdeGetter(context)));
    }

    private void initStoreSerde(StateStoreContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName);
        this.serdes = new StateSerdes<K, V>(changelogTopic != null ? changelogTopic : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName, this.taskId.topologyName()), WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), this.prepareValueSerdeForStore(this.valueSerde, new SerdeGetter(context)));
    }

    @Override
    public boolean setFlushListener(final CacheFlushListener<K, V> listener, boolean sendOldValues) {
        KeyValueStore wrapped = (KeyValueStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener(new CacheFlushListener<byte[], byte[]>(){

                @Override
                public void apply(byte[] rawKey, byte[] rawNewValue, byte[] rawOldValue, long timestamp) {
                    listener.apply(MeteredKeyValueStore.this.serdes.keyFrom(rawKey), rawNewValue != null ? (Object)MeteredKeyValueStore.this.serdes.valueFrom(rawNewValue) : null, rawOldValue != null ? (Object)MeteredKeyValueStore.this.serdes.valueFrom(rawOldValue) : null, timestamp);
                }

                @Override
                public void apply(Record<byte[], Change<byte[]>> record) {
                    listener.apply(record.withKey(MeteredKeyValueStore.this.serdes.keyFrom(record.key())).withValue(new Change<Object>((record.value().newValue != null ? (Object)MeteredKeyValueStore.this.serdes.valueFrom((byte[])record.value().newValue) : null), (record.value().oldValue != null ? (Object)MeteredKeyValueStore.this.serdes.valueFrom((byte[])record.value().oldValue) : null))));
                }
            }, sendOldValues);
        }
        return false;
    }

    @Override
    public V get(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).get(this.keyBytes(key))), this.time, this.getSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, e);
        }
    }

    @Override
    public void put(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> ((KeyValueStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value)), this.time, this.putSensor);
            this.maybeRecordE2ELatency();
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, e);
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        Object currentValue = StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue(((KeyValueStore)this.wrapped()).putIfAbsent(this.keyBytes(key), this.serdes.rawValue(value))), this.time, this.putIfAbsentSensor);
        this.maybeRecordE2ELatency();
        return (V)currentValue;
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        entries.forEach(entry -> Objects.requireNonNull(entry.key, "key cannot be null"));
        StreamsMetricsImpl.maybeMeasureLatency(() -> ((KeyValueStore)this.wrapped()).putAll(this.innerEntries(entries)), this.time, this.putAllSensor);
    }

    @Override
    public V delete(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).delete(this.keyBytes(key))), this.time, this.deleteSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, e);
        }
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<K, V> prefixScan(P prefix, PS prefixKeySerializer) {
        Objects.requireNonNull(prefix, "prefix cannot be null");
        Objects.requireNonNull(prefixKeySerializer, "prefixKeySerializer cannot be null");
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).prefixScan(prefix, prefixKeySerializer), this.prefixScanSensor);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        byte[] serFrom = from == null ? null : this.serdes.rawKey(from);
        byte[] serTo = to == null ? null : this.serdes.rawKey(to);
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).range(Bytes.wrap(serFrom), Bytes.wrap(serTo)), this.rangeSensor);
    }

    @Override
    public KeyValueIterator<K, V> reverseRange(K from, K to) {
        byte[] serFrom = from == null ? null : this.serdes.rawKey(from);
        byte[] serTo = to == null ? null : this.serdes.rawKey(to);
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).reverseRange(Bytes.wrap(serFrom), Bytes.wrap(serTo)), this.rangeSensor);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).all(), this.allSensor);
    }

    @Override
    public KeyValueIterator<K, V> reverseAll() {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).reverseAll(), this.allSensor);
    }

    @Override
    public void flush() {
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.flush(), this.time, this.flushSensor);
    }

    @Override
    public long approximateNumEntries() {
        return ((KeyValueStore)this.wrapped()).approximateNumEntries();
    }

    @Override
    public void close() {
        try {
            ((KeyValueStore)this.wrapped()).close();
        }
        finally {
            this.streamsMetrics.removeAllStoreLevelSensorsAndMetrics(this.taskId.toString(), this.name());
        }
    }

    protected V outerValue(byte[] value) {
        return value != null ? (V)this.serdes.valueFrom(value) : null;
    }

    protected Bytes keyBytes(K key) {
        return Bytes.wrap(this.serdes.rawKey(key));
    }

    private List<KeyValue<Bytes, byte[]>> innerEntries(List<KeyValue<K, V>> from) {
        ArrayList<KeyValue<Bytes, byte[]>> byteEntries = new ArrayList<KeyValue<Bytes, byte[]>>();
        for (KeyValue<K, V> entry : from) {
            byteEntries.add(KeyValue.pair(Bytes.wrap(this.serdes.rawKey(entry.key)), this.serdes.rawValue(entry.value)));
        }
        return byteEntries;
    }

    private void maybeRecordE2ELatency() {
        if (this.e2eLatencySensor.shouldRecord() && this.context != null) {
            long currentTime = this.time.milliseconds();
            long e2eLatency = currentTime - this.context.timestamp();
            this.e2eLatencySensor.record(e2eLatency, currentTime);
        }
    }

    private class MeteredKeyValueIterator
    implements KeyValueIterator<K, V> {
        private final KeyValueIterator<Bytes, byte[]> iter;
        private final Sensor sensor;
        private final long startNs;

        private MeteredKeyValueIterator(KeyValueIterator<Bytes, byte[]> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = MeteredKeyValueStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            KeyValue keyValue = (KeyValue)this.iter.next();
            return KeyValue.pair(MeteredKeyValueStore.this.serdes.keyFrom(((Bytes)keyValue.key).get()), MeteredKeyValueStore.this.outerValue((byte[])keyValue.value));
        }

        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                this.sensor.record(MeteredKeyValueStore.this.time.nanoseconds() - this.startNs);
            }
        }

        @Override
        public K peekNextKey() {
            return MeteredKeyValueStore.this.serdes.keyFrom(this.iter.peekNextKey().get());
        }
    }
}

