/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;

public class LeftOrRightValueDeserializer<V1, V2>
implements WrappingNullableDeserializer<LeftOrRightValue<V1, V2>, Void, Object> {
    public Deserializer<V1> leftDeserializer;
    public Deserializer<V2> rightDeserializer;

    public LeftOrRightValueDeserializer(Deserializer<V1> leftDeserializer, Deserializer<V2> rightDeserializer) {
        this.leftDeserializer = leftDeserializer;
        this.rightDeserializer = rightDeserializer;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.leftDeserializer == null) {
            this.leftDeserializer = getter.valueSerde().deserializer();
        }
        if (this.rightDeserializer == null) {
            this.rightDeserializer = getter.valueSerde().deserializer();
        }
        WrappingNullableUtils.initNullableDeserializer(this.leftDeserializer, getter);
        WrappingNullableUtils.initNullableDeserializer(this.rightDeserializer, getter);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.leftDeserializer.configure(configs, isKey);
        this.rightDeserializer.configure(configs, isKey);
    }

    @Override
    public LeftOrRightValue<V1, V2> deserialize(String topic, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return data[0] == 1 ? LeftOrRightValue.makeLeftValue(this.leftDeserializer.deserialize(topic, this.rawValue(data))) : LeftOrRightValue.makeRightValue(this.rightDeserializer.deserialize(topic, this.rawValue(data)));
    }

    private byte[] rawValue(byte[] data) {
        byte[] rawValue = new byte[data.length - 1];
        System.arraycopy(data, 1, rawValue, 0, rawValue.length);
        return rawValue;
    }
}

