/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.ConstrainedPrioritySet;

final class TaskMovement {
    private final TaskId task;
    private final UUID destination;
    private final SortedSet<UUID> caughtUpClients;

    private TaskMovement(TaskId task, UUID destination, SortedSet<UUID> caughtUpClients) {
        this.task = task;
        this.destination = destination;
        this.caughtUpClients = caughtUpClients;
        if (caughtUpClients == null || caughtUpClients.isEmpty()) {
            throw new IllegalStateException("Should not attempt to move a task if no caught up clients exist");
        }
    }

    private TaskId task() {
        return this.task;
    }

    private int numCaughtUpClients() {
        return this.caughtUpClients.size();
    }

    private static boolean taskIsNotCaughtUpOnClientAndOtherCaughtUpClientsExist(TaskId task, UUID client, Map<TaskId, SortedSet<UUID>> tasksToCaughtUpClients) {
        return !TaskMovement.taskIsCaughtUpOnClientOrNoCaughtUpClientsExist(task, client, tasksToCaughtUpClients);
    }

    private static boolean taskIsCaughtUpOnClientOrNoCaughtUpClientsExist(TaskId task, UUID client, Map<TaskId, SortedSet<UUID>> tasksToCaughtUpClients) {
        Set caughtUpClients = Objects.requireNonNull(tasksToCaughtUpClients.get(task), "uninitialized set");
        return caughtUpClients.isEmpty() || caughtUpClients.contains(client);
    }

    static int assignActiveTaskMovements(Map<TaskId, SortedSet<UUID>> tasksToCaughtUpClients, Map<UUID, ClientState> clientStates, Map<UUID, Set<TaskId>> warmups, AtomicInteger remainingWarmupReplicas) {
        BiFunction<UUID, TaskId, Boolean> caughtUpPredicate = (client, task) -> TaskMovement.taskIsCaughtUpOnClientOrNoCaughtUpClientsExist(task, client, tasksToCaughtUpClients);
        ConstrainedPrioritySet caughtUpClientsByTaskLoad = new ConstrainedPrioritySet(caughtUpPredicate, client -> ((ClientState)clientStates.get(client)).assignedTaskLoad());
        PriorityQueue<TaskMovement> taskMovements = new PriorityQueue<TaskMovement>(Comparator.comparing(TaskMovement::numCaughtUpClients).thenComparing(TaskMovement::task));
        for (Map.Entry<UUID, ClientState> clientStateEntry : clientStates.entrySet()) {
            UUID client2 = clientStateEntry.getKey();
            ClientState state = clientStateEntry.getValue();
            for (TaskId task2 : state.activeTasks()) {
                if (!TaskMovement.taskIsNotCaughtUpOnClientAndOtherCaughtUpClientsExist(task2, client2, tasksToCaughtUpClients)) continue;
                taskMovements.add(new TaskMovement(task2, client2, tasksToCaughtUpClients.get(task2)));
            }
            caughtUpClientsByTaskLoad.offer(client2);
        }
        int movementsNeeded = taskMovements.size();
        for (TaskMovement movement : taskMovements) {
            UUID standbySourceClient = caughtUpClientsByTaskLoad.poll(movement.task, c -> ((ClientState)clientStates.get(c)).hasStandbyTask(movement.task));
            if (standbySourceClient == null) {
                UUID sourceClient = Objects.requireNonNull(caughtUpClientsByTaskLoad.poll(movement.task), "Tried to move task to caught-up client but none exist");
                TaskMovement.moveActiveAndTryToWarmUp(remainingWarmupReplicas, movement.task, clientStates.get(sourceClient), clientStates.get(movement.destination), warmups.computeIfAbsent(movement.destination, x -> new TreeSet()));
                caughtUpClientsByTaskLoad.offerAll(Arrays.asList(sourceClient, movement.destination));
                continue;
            }
            TaskMovement.swapStandbyAndActive(movement.task, clientStates.get(standbySourceClient), clientStates.get(movement.destination));
            caughtUpClientsByTaskLoad.offerAll(Arrays.asList(standbySourceClient, movement.destination));
        }
        return movementsNeeded;
    }

    static int assignStandbyTaskMovements(Map<TaskId, SortedSet<UUID>> tasksToCaughtUpClients, Map<UUID, ClientState> clientStates, AtomicInteger remainingWarmupReplicas, Map<UUID, Set<TaskId>> warmups) {
        BiFunction<UUID, TaskId, Boolean> caughtUpPredicate = (client, task) -> TaskMovement.taskIsCaughtUpOnClientOrNoCaughtUpClientsExist(task, client, tasksToCaughtUpClients);
        ConstrainedPrioritySet caughtUpClientsByTaskLoad = new ConstrainedPrioritySet(caughtUpPredicate, client -> ((ClientState)clientStates.get(client)).assignedTaskLoad());
        PriorityQueue<TaskMovement> taskMovements = new PriorityQueue<TaskMovement>(Comparator.comparing(TaskMovement::numCaughtUpClients).thenComparing(TaskMovement::task));
        for (Map.Entry<UUID, ClientState> clientStateEntry : clientStates.entrySet()) {
            UUID destination = clientStateEntry.getKey();
            ClientState state = clientStateEntry.getValue();
            for (TaskId task2 : state.standbyTasks()) {
                if (warmups.getOrDefault(destination, Collections.emptySet()).contains(task2) || !TaskMovement.taskIsNotCaughtUpOnClientAndOtherCaughtUpClientsExist(task2, destination, tasksToCaughtUpClients)) continue;
                taskMovements.add(new TaskMovement(task2, destination, tasksToCaughtUpClients.get(task2)));
            }
            caughtUpClientsByTaskLoad.offer(destination);
        }
        int movementsNeeded = 0;
        for (TaskMovement movement : taskMovements) {
            UUID sourceClient = caughtUpClientsByTaskLoad.poll(movement.task, clientId -> !((ClientState)clientStates.get(clientId)).hasAssignedTask(movement.task));
            if (sourceClient == null) continue;
            TaskMovement.moveStandbyAndTryToWarmUp(remainingWarmupReplicas, movement.task, clientStates.get(sourceClient), clientStates.get(movement.destination));
            caughtUpClientsByTaskLoad.offerAll(Arrays.asList(sourceClient, movement.destination));
            ++movementsNeeded;
        }
        return movementsNeeded;
    }

    private static void moveActiveAndTryToWarmUp(AtomicInteger remainingWarmupReplicas, TaskId task, ClientState sourceClientState, ClientState destinationClientState, Set<TaskId> warmups) {
        sourceClientState.assignActive(task);
        if (remainingWarmupReplicas.getAndDecrement() > 0) {
            destinationClientState.unassignActive(task);
            destinationClientState.assignStandby(task);
            warmups.add(task);
        } else {
            destinationClientState.unassignActive(task);
        }
    }

    private static void moveStandbyAndTryToWarmUp(AtomicInteger remainingWarmupReplicas, TaskId task, ClientState sourceClientState, ClientState destinationClientState) {
        sourceClientState.assignStandby(task);
        if (remainingWarmupReplicas.getAndDecrement() <= 0) {
            destinationClientState.unassignStandby(task);
        }
    }

    private static void swapStandbyAndActive(TaskId task, ClientState sourceClientState, ClientState destinationClientState) {
        sourceClientState.unassignStandby(task);
        sourceClientState.assignActive(task);
        destinationClientState.unassignActive(task);
        destinationClientState.assignStandby(task);
    }
}

