/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.internals.generated.SubscriptionInfoData;
import org.apache.kafka.streams.processor.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionInfo.class);
    static final int UNKNOWN = -1;
    static final int MIN_VERSION_OFFSET_SUM_SUBSCRIPTION = 7;
    public static final long UNKNOWN_OFFSET_SUM = -3L;
    private final SubscriptionInfoData data;
    private Set<TaskId> prevTasksCache = null;
    private Set<TaskId> standbyTasksCache = null;
    private Map<TaskId, Long> taskOffsetSumsCache = null;

    private static void validateVersions(int version, int latestSupportedVersion) {
        if (latestSupportedVersion == -1 && (version < 1 || version > 2)) {
            throw new IllegalArgumentException("Only versions 1 and 2 are expected to use an UNKNOWN (-1) latest supported version. Got " + version + ".");
        }
        if (latestSupportedVersion != -1 && (version < 1 || version > latestSupportedVersion)) {
            throw new IllegalArgumentException("version must be between 1 and " + latestSupportedVersion + "; was: " + version);
        }
    }

    public SubscriptionInfo(int version, int latestSupportedVersion, UUID processId, String userEndPoint, Map<TaskId, Long> taskOffsetSums, byte uniqueField, int errorCode) {
        SubscriptionInfo.validateVersions(version, latestSupportedVersion);
        SubscriptionInfoData data = new SubscriptionInfoData();
        data.setVersion(version);
        data.setProcessId(new Uuid(processId.getMostSignificantBits(), processId.getLeastSignificantBits()));
        if (version >= 2) {
            data.setUserEndPoint(userEndPoint == null ? new byte[]{} : userEndPoint.getBytes(StandardCharsets.UTF_8));
        }
        if (version >= 3) {
            data.setLatestSupportedVersion(latestSupportedVersion);
        }
        if (version >= 8) {
            data.setUniqueField(uniqueField);
        }
        if (version >= 9) {
            data.setErrorCode(errorCode);
        }
        this.data = data;
        if (version >= 10) {
            this.setTaskOffsetSumDataWithNamedTopologiesFromTaskOffsetSumMap(taskOffsetSums);
        } else if (version >= 7) {
            this.setTaskOffsetSumDataFromTaskOffsetSumMap(taskOffsetSums);
        } else {
            this.setPrevAndStandbySetsFromParsedTaskOffsetSumMap(taskOffsetSums);
        }
    }

    private SubscriptionInfo(SubscriptionInfoData subscriptionInfoData) {
        SubscriptionInfo.validateVersions(subscriptionInfoData.version(), subscriptionInfoData.latestSupportedVersion());
        this.data = subscriptionInfoData;
    }

    public int errorCode() {
        return this.data.errorCode();
    }

    private void setTaskOffsetSumDataWithNamedTopologiesFromTaskOffsetSumMap(Map<TaskId, Long> taskOffsetSums) {
        this.data.setTaskOffsetSums(taskOffsetSums.entrySet().stream().map(t -> {
            SubscriptionInfoData.TaskOffsetSum taskOffsetSum = new SubscriptionInfoData.TaskOffsetSum();
            TaskId task = (TaskId)t.getKey();
            taskOffsetSum.setTopicGroupId(task.subtopology());
            taskOffsetSum.setPartition(task.partition());
            taskOffsetSum.setNamedTopology(task.topologyName());
            taskOffsetSum.setOffsetSum((Long)t.getValue());
            return taskOffsetSum;
        }).collect(Collectors.toList()));
    }

    private void setTaskOffsetSumDataFromTaskOffsetSumMap(Map<TaskId, Long> taskOffsetSums) {
        HashMap<Integer, List> topicGroupIdToPartitionOffsetSum = new HashMap<Integer, List>();
        for (Map.Entry<TaskId, Long> taskEntry : taskOffsetSums.entrySet()) {
            TaskId task = taskEntry.getKey();
            if (task.topologyName() != null) {
                throw new TaskAssignmentException("Named topologies are not compatible with older protocol versions");
            }
            topicGroupIdToPartitionOffsetSum.computeIfAbsent(task.subtopology(), t -> new ArrayList()).add(new SubscriptionInfoData.PartitionToOffsetSum().setPartition(task.partition()).setOffsetSum(taskEntry.getValue()));
        }
        this.data.setTaskOffsetSums(topicGroupIdToPartitionOffsetSum.entrySet().stream().map(t -> {
            SubscriptionInfoData.TaskOffsetSum taskOffsetSum = new SubscriptionInfoData.TaskOffsetSum();
            taskOffsetSum.setTopicGroupId((Integer)t.getKey());
            taskOffsetSum.setPartitionToOffsetSum((List)t.getValue());
            return taskOffsetSum;
        }).collect(Collectors.toList()));
    }

    private void setPrevAndStandbySetsFromParsedTaskOffsetSumMap(Map<TaskId, Long> taskOffsetSums) {
        HashSet<TaskId> prevTasks = new HashSet<TaskId>();
        HashSet<TaskId> standbyTasks = new HashSet<TaskId>();
        for (Map.Entry<TaskId, Long> taskOffsetSum : taskOffsetSums.entrySet()) {
            if (taskOffsetSum.getKey().topologyName() != null) {
                throw new TaskAssignmentException("Named topologies are not compatible with older protocol versions");
            }
            if (taskOffsetSum.getValue() == -2L) {
                prevTasks.add(taskOffsetSum.getKey());
                continue;
            }
            standbyTasks.add(taskOffsetSum.getKey());
        }
        this.data.setPrevTasks(prevTasks.stream().map(t -> {
            SubscriptionInfoData.TaskId taskId = new SubscriptionInfoData.TaskId();
            taskId.setTopicGroupId(t.subtopology());
            taskId.setPartition(t.partition());
            return taskId;
        }).collect(Collectors.toList()));
        this.data.setStandbyTasks(standbyTasks.stream().map(t -> {
            SubscriptionInfoData.TaskId taskId = new SubscriptionInfoData.TaskId();
            taskId.setTopicGroupId(t.subtopology());
            taskId.setPartition(t.partition());
            return taskId;
        }).collect(Collectors.toList()));
    }

    public int version() {
        return this.data.version();
    }

    public int latestSupportedVersion() {
        return this.data.latestSupportedVersion();
    }

    public UUID processId() {
        return new UUID(this.data.processId().getMostSignificantBits(), this.data.processId().getLeastSignificantBits());
    }

    public Set<TaskId> prevTasks() {
        if (this.prevTasksCache == null) {
            this.prevTasksCache = this.data.version() >= 7 ? SubscriptionInfo.getActiveTasksFromTaskOffsetSumMap(this.taskOffsetSums()) : Collections.unmodifiableSet(this.data.prevTasks().stream().map(t -> new TaskId(t.topicGroupId(), t.partition())).collect(Collectors.toSet()));
        }
        return this.prevTasksCache;
    }

    public Set<TaskId> standbyTasks() {
        if (this.standbyTasksCache == null) {
            this.standbyTasksCache = this.data.version() >= 7 ? SubscriptionInfo.getStandbyTasksFromTaskOffsetSumMap(this.taskOffsetSums()) : Collections.unmodifiableSet(this.data.standbyTasks().stream().map(t -> new TaskId(t.topicGroupId(), t.partition())).collect(Collectors.toSet()));
        }
        return this.standbyTasksCache;
    }

    public Map<TaskId, Long> taskOffsetSums() {
        if (this.taskOffsetSumsCache == null) {
            this.taskOffsetSumsCache = new HashMap<TaskId, Long>();
            if (this.data.version() >= 7) {
                for (SubscriptionInfoData.TaskOffsetSum taskOffsetSum : this.data.taskOffsetSums()) {
                    if (this.data.version() >= 10) {
                        this.taskOffsetSumsCache.put(new TaskId(taskOffsetSum.topicGroupId(), taskOffsetSum.partition(), taskOffsetSum.namedTopology()), taskOffsetSum.offsetSum());
                        continue;
                    }
                    for (SubscriptionInfoData.PartitionToOffsetSum partitionOffsetSum : taskOffsetSum.partitionToOffsetSum()) {
                        this.taskOffsetSumsCache.put(new TaskId(taskOffsetSum.topicGroupId(), partitionOffsetSum.partition()), partitionOffsetSum.offsetSum());
                    }
                }
            } else {
                this.prevTasks().forEach(taskId -> this.taskOffsetSumsCache.put((TaskId)taskId, -2L));
                this.standbyTasks().forEach(taskId -> this.taskOffsetSumsCache.put((TaskId)taskId, -3L));
            }
        }
        return this.taskOffsetSumsCache;
    }

    public String userEndPoint() {
        return this.data.userEndPoint() == null || this.data.userEndPoint().length == 0 ? null : new String(this.data.userEndPoint(), StandardCharsets.UTF_8);
    }

    public static Set<TaskId> getActiveTasksFromTaskOffsetSumMap(Map<TaskId, Long> taskOffsetSums) {
        return SubscriptionInfo.taskOffsetSumMapToTaskSet(taskOffsetSums, true);
    }

    public static Set<TaskId> getStandbyTasksFromTaskOffsetSumMap(Map<TaskId, Long> taskOffsetSums) {
        return SubscriptionInfo.taskOffsetSumMapToTaskSet(taskOffsetSums, false);
    }

    private static Set<TaskId> taskOffsetSumMapToTaskSet(Map<TaskId, Long> taskOffsetSums, boolean getActiveTasks) {
        return taskOffsetSums.entrySet().stream().filter(t -> getActiveTasks == ((Long)t.getValue() == -2L)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public ByteBuffer encode() {
        if (this.data.version() > 10) {
            throw new IllegalStateException("Should never try to encode a SubscriptionInfo with version [" + this.data.version() + "] > LATEST_SUPPORTED_VERSION [" + 10 + "]");
        }
        return MessageUtil.toByteBuffer(this.data, (short)this.data.version());
    }

    public static SubscriptionInfo decode(ByteBuffer data) {
        data.rewind();
        int version = data.getInt();
        if (version > 10) {
            int latestSupportedVersion = data.getInt();
            SubscriptionInfoData subscriptionInfoData = new SubscriptionInfoData();
            subscriptionInfoData.setVersion(version);
            subscriptionInfoData.setLatestSupportedVersion(latestSupportedVersion);
            LOG.info("Unable to decode subscription data: used version: {}; latest supported version: {}", (Object)version, (Object)latestSupportedVersion);
            return new SubscriptionInfo(subscriptionInfoData);
        }
        data.rewind();
        ByteBufferAccessor accessor = new ByteBufferAccessor(data);
        SubscriptionInfoData subscriptionInfoData = new SubscriptionInfoData(accessor, (short)version);
        return new SubscriptionInfo(subscriptionInfoData);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SubscriptionInfo) {
            SubscriptionInfo other = (SubscriptionInfo)o;
            return this.data.equals(other.data);
        }
        return false;
    }

    public String toString() {
        return this.data.toString();
    }

    static {
        int subscriptionInfoLatestVersion = SubscriptionInfoData.SCHEMAS.length - 1;
        if (subscriptionInfoLatestVersion != 10) {
            throw new IllegalArgumentException("streams/src/main/resources/common/message/SubscriptionInfo.json needs to be updated to match the latest assignment protocol version. SubscriptionInfo only supports up to  [" + subscriptionInfoLatestVersion + "] but needs to support up to [" + 10 + "].");
        }
    }
}

