/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.MissingSourceTopicException;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.slf4j.Logger;

public class RepartitionTopics {
    private final InternalTopicManager internalTopicManager;
    private final TopologyMetadata topologyMetadata;
    private final Cluster clusterMetadata;
    private final CopartitionedTopicsEnforcer copartitionedTopicsEnforcer;
    private final Logger log;
    private final Map<TopicPartition, PartitionInfo> topicPartitionInfos = new HashMap<TopicPartition, PartitionInfo>();

    public RepartitionTopics(TopologyMetadata topologyMetadata, InternalTopicManager internalTopicManager, CopartitionedTopicsEnforcer copartitionedTopicsEnforcer, Cluster clusterMetadata, String logPrefix) {
        this.topologyMetadata = topologyMetadata;
        this.internalTopicManager = internalTopicManager;
        this.clusterMetadata = clusterMetadata;
        this.copartitionedTopicsEnforcer = copartitionedTopicsEnforcer;
        LogContext logContext = new LogContext(logPrefix);
        this.log = logContext.logger(this.getClass());
    }

    public void setup() {
        Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups = this.topologyMetadata.topicGroups();
        Map<String, InternalTopicConfig> repartitionTopicMetadata = this.computeRepartitionTopicConfig(topicGroups, this.clusterMetadata);
        this.ensureCopartitioning(this.topologyMetadata.copartitionGroups(), repartitionTopicMetadata, this.clusterMetadata);
        this.internalTopicManager.makeReady(repartitionTopicMetadata);
        for (Map.Entry<String, InternalTopicConfig> entry : repartitionTopicMetadata.entrySet()) {
            String topic = entry.getKey();
            int numPartitions = entry.getValue().numberOfPartitions().orElse(-1);
            for (int partition = 0; partition < numPartitions; ++partition) {
                this.topicPartitionInfos.put(new TopicPartition(topic, partition), new PartitionInfo(topic, partition, null, new Node[0], new Node[0]));
            }
        }
    }

    public Map<TopicPartition, PartitionInfo> topicPartitionsInfo() {
        return Collections.unmodifiableMap(this.topicPartitionInfos);
    }

    private Map<String, InternalTopicConfig> computeRepartitionTopicConfig(Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups, Cluster clusterMetadata) {
        HashMap<String, InternalTopicConfig> repartitionTopicConfigs = new HashMap<String, InternalTopicConfig>();
        for (InternalTopologyBuilder.TopicsInfo topicsInfo : topicGroups.values()) {
            this.checkIfExternalSourceTopicsExist(topicsInfo, clusterMetadata);
            repartitionTopicConfigs.putAll(topicsInfo.repartitionSourceTopics.values().stream().collect(Collectors.toMap(InternalTopicConfig::name, topicConfig -> topicConfig)));
        }
        this.setRepartitionSourceTopicPartitionCount(repartitionTopicConfigs, topicGroups, clusterMetadata);
        return repartitionTopicConfigs;
    }

    private void ensureCopartitioning(Collection<Set<String>> copartitionGroups, Map<String, InternalTopicConfig> repartitionTopicMetadata, Cluster clusterMetadata) {
        for (Set<String> copartitionGroup : copartitionGroups) {
            this.copartitionedTopicsEnforcer.enforce(copartitionGroup, repartitionTopicMetadata, clusterMetadata);
        }
    }

    private void checkIfExternalSourceTopicsExist(InternalTopologyBuilder.TopicsInfo topicsInfo, Cluster clusterMetadata) {
        HashSet<String> missingExternalSourceTopics = new HashSet<String>(topicsInfo.sourceTopics);
        missingExternalSourceTopics.removeAll(topicsInfo.repartitionSourceTopics.keySet());
        missingExternalSourceTopics.removeAll(clusterMetadata.topics());
        if (!missingExternalSourceTopics.isEmpty()) {
            this.log.error("The following source topics are missing/unknown: {}. Please make sure all source topics have been pre-created before starting the Streams application. ", missingExternalSourceTopics);
            throw new MissingSourceTopicException("Missing source topics.");
        }
    }

    private void setRepartitionSourceTopicPartitionCount(Map<String, InternalTopicConfig> repartitionTopicMetadata, Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups, Cluster clusterMetadata) {
        boolean partitionCountNeeded;
        do {
            partitionCountNeeded = false;
            boolean progressMadeThisIteration = false;
            for (InternalTopologyBuilder.TopicsInfo topicsInfo : topicGroups.values()) {
                for (String repartitionSourceTopic : topicsInfo.repartitionSourceTopics.keySet()) {
                    Optional<Integer> repartitionSourceTopicPartitionCount = repartitionTopicMetadata.get(repartitionSourceTopic).numberOfPartitions();
                    if (repartitionSourceTopicPartitionCount.isPresent()) continue;
                    Integer numPartitions = this.computePartitionCount(repartitionTopicMetadata, topicGroups, clusterMetadata, repartitionSourceTopic);
                    if (numPartitions == null) {
                        partitionCountNeeded = true;
                        this.log.trace("Unable to determine number of partitions for {}, another iteration is needed", (Object)repartitionSourceTopic);
                        continue;
                    }
                    this.log.trace("Determined number of partitions for {} to be {}", (Object)repartitionSourceTopic, (Object)numPartitions);
                    repartitionTopicMetadata.get(repartitionSourceTopic).setNumberOfPartitions(numPartitions);
                    progressMadeThisIteration = true;
                }
            }
            if (progressMadeThisIteration || !partitionCountNeeded) continue;
            this.log.error("Unable to determine the number of partitions of all repartition topics, most likely a source topic is missing or pattern doesn't match any topics\ntopic groups: {}\ncluster topics: {}.", topicGroups, clusterMetadata.topics());
            throw new TaskAssignmentException("Failed to compute number of partitions for all repartition topics, make sure all user input topics are created and all Pattern subscriptions match at least one topic in the cluster");
        } while (partitionCountNeeded);
    }

    private Integer computePartitionCount(Map<String, InternalTopicConfig> repartitionTopicMetadata, Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups, Cluster clusterMetadata, String repartitionSourceTopic) {
        Integer partitionCount = null;
        for (InternalTopologyBuilder.TopicsInfo topicsInfo : topicGroups.values()) {
            Set<String> sinkTopics = topicsInfo.sinkTopics;
            if (!sinkTopics.contains(repartitionSourceTopic)) continue;
            for (String upstreamSourceTopic : topicsInfo.sourceTopics) {
                Integer numPartitionsCandidate = null;
                if (repartitionTopicMetadata.containsKey(upstreamSourceTopic)) {
                    if (repartitionTopicMetadata.get(upstreamSourceTopic).numberOfPartitions().isPresent()) {
                        numPartitionsCandidate = repartitionTopicMetadata.get(upstreamSourceTopic).numberOfPartitions().get();
                    }
                } else {
                    Integer count = clusterMetadata.partitionCountForTopic(upstreamSourceTopic);
                    if (count == null) {
                        throw new TaskAssignmentException("No partition count found for source topic " + upstreamSourceTopic + ", but it should have been.");
                    }
                    numPartitionsCandidate = count;
                }
                if (numPartitionsCandidate == null || partitionCount != null && numPartitionsCandidate <= partitionCount) continue;
                partitionCount = numPartitionsCandidate;
            }
        }
        return partitionCount;
    }
}

