/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public class ChangedSerializer<T>
implements Serializer<Change<T>>,
WrappingNullableSerializer<Change<T>, Void, T> {
    private static final int NEWFLAG_SIZE = 1;
    private Serializer<T> inner;

    public ChangedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    public Serializer<T> inner() {
        return this.inner;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.inner == null) {
            this.inner = getter.valueSerde().serializer();
        }
    }

    @Override
    public byte[] serialize(String topic, Headers headers, Change<T> data) {
        byte[] serializedKey;
        if (data.newValue != null) {
            if (data.oldValue != null) {
                throw new StreamsException("Both old and new values are not null (" + data.oldValue + " : " + data.newValue + ") in ChangeSerializer, which is not allowed.");
            }
            serializedKey = this.inner.serialize(topic, headers, data.newValue);
        } else {
            if (data.oldValue == null) {
                throw new StreamsException("Both old and new values are null in ChangeSerializer, which is not allowed.");
            }
            serializedKey = this.inner.serialize(topic, headers, data.oldValue);
        }
        ByteBuffer buf = ByteBuffer.allocate(serializedKey.length + 1);
        buf.put(serializedKey);
        buf.put((byte)(data.newValue != null ? 1 : 0));
        return buf.array();
    }

    @Override
    public byte[] serialize(String topic, Change<T> data) {
        return this.serialize(topic, (Headers)null, data);
    }

    @Override
    public void close() {
        this.inner.close();
    }
}

