/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.NamedOperation;

public class Printed<K, V>
implements NamedOperation<Printed<K, V>> {
    protected final OutputStream outputStream;
    protected String label;
    protected String processorName;
    protected KeyValueMapper<? super K, ? super V, String> mapper = (key, value) -> String.format("%s, %s", key, value);

    private Printed(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected Printed(Printed<K, V> printed) {
        this.outputStream = printed.outputStream;
        this.label = printed.label;
        this.mapper = printed.mapper;
        this.processorName = printed.processorName;
    }

    public static <K, V> Printed<K, V> toFile(String filePath) {
        Objects.requireNonNull(filePath, "filePath can't be null");
        if (Utils.isBlank(filePath)) {
            throw new TopologyException("filePath can't be an empty string");
        }
        try {
            return new Printed<K, V>(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new TopologyException("Unable to write stream to file at [" + filePath + "] " + e.getMessage());
        }
    }

    public static <K, V> Printed<K, V> toSysOut() {
        return new Printed<K, V>(System.out);
    }

    public Printed<K, V> withLabel(String label) {
        Objects.requireNonNull(label, "label can't be null");
        this.label = label;
        return this;
    }

    public Printed<K, V> withKeyValueMapper(KeyValueMapper<? super K, ? super V, String> mapper) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        this.mapper = mapper;
        return this;
    }

    @Override
    public Printed<K, V> withName(String processorName) {
        this.processorName = processorName;
        return this;
    }
}

