/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.api.AddWatchBuilder;
import org.apache.curator.framework.api.AddWatchBuilder2;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.WatchableBase;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.Watching;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.Watcher;

public class AddWatchBuilderImpl
implements AddWatchBuilder,
Pathable<Void>,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Watching watching;
    private Backgrounding backgrounding = new Backgrounding();
    private AddWatchMode mode = AddWatchMode.PERSISTENT_RECURSIVE;

    AddWatchBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.watching = new Watching(client, true);
    }

    public AddWatchBuilderImpl(CuratorFrameworkImpl client, Watching watching, Backgrounding backgrounding, AddWatchMode mode) {
        this.client = client;
        this.watching = watching;
        this.backgrounding = backgrounding;
        this.mode = mode;
    }

    @Override
    public WatchableBase<Pathable<Void>> inBackground() {
        this.backgrounding = new Backgrounding();
        return this;
    }

    @Override
    public AddWatchBuilder2 withMode(AddWatchMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public Pathable<Void> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public Pathable<Void> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public WatchableBase<Pathable<Void>> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public WatchableBase<Pathable<Void>> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public WatchableBase<Pathable<Void>> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public WatchableBase<Pathable<Void>> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(callback, executor);
        return this;
    }

    @Override
    public WatchableBase<Pathable<Void>> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public Void forPath(String path) throws Exception {
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), this.watching), null);
        } else {
            this.pathInForeground(path);
        }
        return null;
    }

    @Override
    public void performBackgroundOperation(OperationAndData<String> data) throws Exception {
        String path = data.getData();
        String fixedPath = this.client.fixForNamespace(path);
        try {
            OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("AddWatchBuilderImpl-Background");
            if (this.watching.isWatched()) {
                this.client.getZooKeeper().addWatch(fixedPath, this.mode, (rc, path1, ctx) -> {
                    trace.setReturnCode(rc).setWithWatcher(true).setPath(path1).commit();
                    CuratorEventImpl event = new CuratorEventImpl(this.client, CuratorEventType.ADD_WATCH, rc, path1, null, ctx, null, null, null, null, null, null);
                    this.client.processBackgroundOperation(data, event);
                }, this.backgrounding.getContext());
            } else {
                this.client.getZooKeeper().addWatch(fixedPath, this.watching.getWatcher(path), this.mode, (rc, path1, ctx) -> {
                    trace.setReturnCode(rc).setWithWatcher(true).setPath(path1).commit();
                    CuratorEventImpl event = new CuratorEventImpl(this.client, CuratorEventType.ADD_WATCH, rc, path1, null, ctx, null, null, null, null, null, null);
                    this.client.processBackgroundOperation(data, event);
                }, this.backgrounding.getContext());
            }
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, this.watching);
        }
    }

    private void pathInForeground(String path) throws Exception {
        String fixedPath = this.client.fixForNamespace(path);
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("AddWatchBuilderImpl-Foreground");
        RetryLoop.callWithRetry(this.client.getZookeeperClient(), () -> {
            if (this.watching.isWatched()) {
                this.client.getZooKeeper().addWatch(fixedPath, this.mode);
            } else {
                this.client.getZooKeeper().addWatch(fixedPath, this.watching.getWatcher(path), this.mode);
            }
            return null;
        });
        trace.setPath(fixedPath).setWithWatcher(true).commit();
    }
}

