/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.FieldGroup;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;

abstract class SelfDescribingTriviallyCopyable
extends SelfDescribingMarshallable {
    @FieldGroup(value="header")
    transient int description = this.$description();

    SelfDescribingTriviallyCopyable() {
    }

    protected abstract int $description();

    protected abstract int $start();

    protected abstract int $length();

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        int description0 = bytes.readInt();
        if (description0 != this.$description()) {
            this.carefulCopy(bytes, description0);
        } else {
            bytes.unsafeReadObject(this, this.$start(), this.$length());
        }
    }

    private void carefulCopy(BytesIn in, int description0) {
        int offset = this.$start();
        int longs = this.$description() >>> 24;
        int longs0 = description0 >>> 24;
        for (int i = 0; i < Math.max(longs, longs0); ++i) {
            long value = 0L;
            if (i < longs0) {
                value = in.readLong();
            }
            if (i >= longs) continue;
            UnsafeMemory.MEMORY.writeLong(this, offset, value);
            offset += 8;
        }
        int ints = this.$description() >>> 16 & 0xFF;
        int ints0 = description0 >>> 16 & 0xFF;
        for (int i = 0; i < Math.max(ints, ints0); ++i) {
            int value = 0;
            if (i < ints0) {
                value = in.readInt();
            }
            if (i >= ints) continue;
            UnsafeMemory.MEMORY.writeInt(this, offset, value);
            offset += 4;
        }
        int shorts = this.$description() >>> 8 & 0x7F;
        int shorts0 = description0 >>> 8 & 0x7F;
        for (int i = 0; i < Math.max(shorts, shorts0); ++i) {
            short value = 0;
            if (i < shorts0) {
                value = in.readShort();
            }
            if (i >= shorts) continue;
            UnsafeMemory.MEMORY.writeShort(this, offset, value);
            offset += 2;
        }
        int bytes = this.$description() & 0xFF;
        int bytes0 = description0 & 0xFF;
        for (int i = 0; i < Math.max(bytes, bytes0); ++i) {
            byte value = 0;
            if (i < bytes0) {
                value = in.readByte();
            }
            if (i >= bytes) continue;
            UnsafeMemory.MEMORY.writeByte(this, offset, value);
            ++offset;
        }
    }

    @Override
    public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException {
        bytes.writeInt(this.$description());
        bytes.unsafeWriteObject(this, this.$start(), this.$length());
    }
}

