/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Stream;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.Resettable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.HashWire;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DontChain
public interface Marshallable
extends WriteMarshallable,
ReadMarshallable,
Resettable {
    public static boolean $equals(@NotNull WriteMarshallable $this, Object o) {
        return o instanceof WriteMarshallable && ($this == o || Wires.isEquals($this, o));
    }

    public static int $hashCode(WriteMarshallable $this) {
        return HashWire.hash32($this);
    }

    public static String $toString(WriteMarshallable $this) {
        return WireType.TEXT.asString($this);
    }

    @Nullable
    public static <T> T fromString(@NotNull CharSequence cs) {
        return WireType.TEXT.fromString(cs);
    }

    @Nullable
    public static <T> T fromString(@NotNull Class<T> tClass, @NotNull CharSequence cs) {
        return WireType.TEXT.fromString(tClass, cs);
    }

    @NotNull
    public static <T> T fromFile(String filename) throws IOException {
        return WireType.TEXT.fromFile(filename);
    }

    public static <T> T fromString(@NotNull InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return WireType.TEXT.fromString(s.hasNext() ? s.next() : "");
    }

    @Nullable
    public static <T> T fromFile(@NotNull Class<T> expectedType, String filename) throws IOException {
        return WireType.TEXT.fromFile(expectedType, filename);
    }

    @NotNull
    public static <T> Stream<T> streamFromFile(String filename) throws IOException {
        return WireType.TEXT.streamFromFile(filename);
    }

    @Nullable
    public static <T> Stream<T> streamFromFile(@NotNull Class<T> expectedType, String filename) throws IOException {
        return WireType.TEXT.streamFromFile(expectedType, filename);
    }

    @Deprecated
    @NotNull
    public static Map<String, Object> fromFileAsMap(String filename) throws IOException {
        return WireType.TEXT.fromFileAsMap(filename, Object.class);
    }

    @Deprecated
    @NotNull
    public static <V> Map<String, V> fromFileAsMap(String filename, @NotNull Class<V> valueClass) throws IOException {
        return WireType.TEXT.fromFileAsMap(filename, valueClass);
    }

    @Deprecated
    @Nullable
    public static Map<String, Object> fromHexString(@NotNull CharSequence cs) {
        return (Map)WireType.READ_ANY.fromHexString(cs);
    }

    @Nullable
    default public <T> T getField(String name, Class<T> tClass) throws NoSuchFieldException {
        return Wires.getField(this, name, tClass);
    }

    default public void setField(String name, Object value) throws NoSuchFieldException {
        Wires.setField(this, name, value);
    }

    default public long getLongField(String name) throws NoSuchFieldException {
        return Wires.getLongField(this, name);
    }

    default public void setLongField(String name, long value) throws NoSuchFieldException {
        Wires.setLongField(this, name, value);
    }

    @Override
    default public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(this.getClass());
        wm.readMarshallable(this, wire, wm.defaultValue(), true);
    }

    @Override
    default public void writeMarshallable(@NotNull WireOut wire) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(this.getClass());
        wm.writeMarshallable(this, wire);
    }

    @NotNull
    default public <T> T deepCopy() {
        return (T)Wires.deepCopy(this);
    }

    @Deprecated
    @NotNull
    default public <T extends Marshallable> T copyFrom(@NotNull T t) {
        return Wires.copyTo(this, t);
    }

    default public <T extends Marshallable> T copyTo(@NotNull T t) {
        return Wires.copyTo(this, t);
    }

    default public <K, T extends Marshallable> T mergeToMap(@NotNull Map<K, T> map, @NotNull Function<T, K> getKey) {
        @NotNull Marshallable t = this;
        return (T)map.merge(getKey.apply(t), t, (p, c) -> p == null ? (Marshallable)c.deepCopy() : p.copyFrom(c));
    }

    @NotNull
    default public List<FieldInfo> $fieldInfos() {
        return Wires.fieldInfos(this.getClass());
    }

    @NotNull
    default public Map<String, FieldInfo> $fieldInfoMap() {
        return Wires.fieldInfoMap(this.getClass());
    }

    default public String className() {
        return ClassAliasPool.CLASS_ALIASES.nameFor(this.getClass());
    }

    @Override
    default public void reset() {
        Wires.reset(this);
    }
}

