/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public class InputStreamToWire {
    private final Bytes<ByteBuffer> bytes = Bytes.elasticHeapByteBuffer(128);
    private final Wire wire;
    private final DataInputStream dis;

    public InputStreamToWire(WireType wireType, InputStream is) {
        this.wire = (Wire)wireType.apply(this.bytes);
        this.dis = new DataInputStream(is);
    }

    public Wire readOne() throws IOException {
        this.wire.clear();
        int length = this.dis.readInt();
        if (length < 0) {
            throw new StreamCorruptedException();
        }
        this.bytes.ensureCapacity(length);
        byte[] array = ((ByteBuffer)this.bytes.underlyingObject()).array();
        this.dis.readFully(array, 0, length);
        this.bytes.readPositionRemaining(0L, length);
        return this.wire;
    }
}

