/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.JDBCResult;
import net.openhft.chronicle.queue.JDBCServiceProvider;
import net.openhft.chronicle.queue.JDBCStatement;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JDBCService
extends AbstractCloseable
implements Closeable,
JDBCServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCService.class);
    @NotNull
    private final ChronicleQueue in;
    private final ChronicleQueue out;
    private final ThrowingSupplier<Connection, SQLException> connectionSupplier;

    @Deprecated
    public JDBCService(@NotNull ChronicleQueue in, ChronicleQueue out, ThrowingSupplier<Connection, SQLException> connectionSupplier) {
        this.in = in;
        this.out = out;
        this.connectionSupplier = connectionSupplier;
        ExecutorService service = Executors.newSingleThreadExecutor(new NamedThreadFactory(in.file().getName() + "-JDBCService", true));
        service.execute(this::runLoop);
        service.shutdown();
    }

    public void runLoop() {
        try {
            JDBCResult result = (JDBCResult)((VanillaMethodWriterBuilder)this.out.acquireAppender().methodWriterBuilder(JDBCResult.class)).get();
            JDBCStatement js = JDBCStatement.create(this.connectionSupplier, result);
            try (ExcerptTailer tailer = this.in.createTailer();){
                MethodReader reader = tailer.afterLastWritten(this.out).methodReader(js);
                Pauser pauser = Pauser.millis(1, 10);
                while (!this.isClosed()) {
                    if (reader.readOne()) {
                        pauser.reset();
                        continue;
                    }
                    pauser.pause();
                }
            }
        }
        catch (Exception t) {
            LOGGER.warn("Run loop exited", (Throwable)t);
        }
    }

    @Override
    protected void performClose() {
    }

    @Override
    @NotNull
    public JDBCStatement createWriter() {
        return (JDBCStatement)((VanillaMethodWriterBuilder)this.in.acquireAppender().methodWriterBuilder(JDBCStatement.class)).get();
    }

    @Override
    @NotNull
    public MethodReader createReader(JDBCResult result) {
        return this.out.createTailer().methodReader(result);
    }
}

