/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.TimeUnit;

public class Timeout {
    private final long timeout;
    private final TimeUnit unit;
    private final long timeoutBase;

    public Timeout(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("The TimeUnit cannot be null");
        }
        this.timeout = timeout;
        this.unit = unit;
        this.timeoutBase = this.getBaseUnit().convert(timeout, unit);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getDeadline() {
        return this.now() + this.timeoutBase;
    }

    public long getTimeoutInBaseUnit() {
        return this.timeoutBase;
    }

    public long getTimeLeft(long deadline) {
        return deadline - this.now();
    }

    public TimeUnit getBaseUnit() {
        return TimeUnit.NANOSECONDS;
    }

    private long now() {
        return System.nanoTime();
    }

    public int hashCode() {
        return 31 * (1 + (int)(this.timeoutBase ^ this.timeoutBase >>> 32));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Timeout)) {
            return false;
        }
        Timeout that = (Timeout)obj;
        return this.timeoutBase == that.timeoutBase;
    }
}

