/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.TimeUnit;
import stormpot.Expiration;
import stormpot.Poolable;
import stormpot.SlotInfo;

public class TimeSpreadExpiration<T extends Poolable>
implements Expiration<T> {
    private final long lowerBoundMillis;
    private final long upperBoundMillis;
    private final TimeUnit unit;

    public TimeSpreadExpiration(long lowerBound, long upperBound, TimeUnit unit) {
        if (lowerBound < 1L) {
            throw new IllegalArgumentException("The lower bound cannot be less than 1.");
        }
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("The upper bound must be greater than the lower bound.");
        }
        if (unit == null) {
            throw new IllegalArgumentException("The TimeUnit cannot be null.");
        }
        this.lowerBoundMillis = unit.toMillis(lowerBound);
        this.upperBoundMillis = unit.toMillis(upperBound);
        this.unit = unit;
    }

    @Override
    public boolean hasExpired(SlotInfo<? extends T> info) {
        long age;
        long expirationAge = info.getStamp();
        if (expirationAge == 0L) {
            long maxDelta = this.upperBoundMillis - this.lowerBoundMillis;
            expirationAge = this.lowerBoundMillis + Math.abs((long)info.randomInt() % maxDelta);
            info.setStamp(expirationAge);
        }
        return (age = info.getAgeMillis()) >= expirationAge;
    }

    public String toString() {
        long lower = this.unit.convert(this.lowerBoundMillis, TimeUnit.MILLISECONDS);
        long upper = this.unit.convert(this.upperBoundMillis, TimeUnit.MILLISECONDS);
        return "TimeSpreadExpiration(" + lower + " to " + upper + " " + (Object)((Object)this.unit) + ")";
    }
}

