/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;

public class DocumentModeAsserter
implements EntryPoint {
    public static final String PROPERTY_DOCUMENT_COMPATMODE = "document.compatMode";
    public static final String PROPERTY_DOCUMENT_COMPATMODE_SEVERITY = "document.compatMode.severity";
    private static final String QUIRKS_MODE_BACK_COMPAT = "BackCompat";
    private static final String STANDARDS_MODE_CSS1_COMPAT = "CSS1Compat";

    @Override
    public void onModuleLoad() {
        DocumentModeProperty impl = (DocumentModeProperty)GWT.create(DocumentModeProperty.class);
        Severity severity = impl.getDocumentModeSeverity();
        if (severity == Severity.IGNORE) {
            return;
        }
        String currentMode = Document.get().getCompatMode();
        String[] allowedModes = impl.getAllowedDocumentModes();
        for (int i = 0; i < allowedModes.length; ++i) {
            if (!allowedModes[i].equals(currentMode)) continue;
            return;
        }
        String message = allowedModes.length == 1 && STANDARDS_MODE_CSS1_COMPAT.equals(allowedModes[0]) && QUIRKS_MODE_BACK_COMPAT.equals(currentMode) ? "GWT no longer supports Quirks Mode (document.compatMode=' BackCompat').<br>Make sure your application's host HTML page has a Standards Mode (document.compatMode=' CSS1Compat') doctype,<br>e.g. by using &lt;!doctype html&gt; at the start of your application's HTML page.<br><br>To continue using this unsupported rendering mode and risk layout problems, suppress this message by adding<br>the following line to your*.gwt.xml module file:<br>&nbsp;&nbsp;&lt;extend-configuration-property name=\"document.compatMode\" value=\"" + currentMode + "\"/&gt;" : "Your *.gwt.xml module configuration prohibits the use of the current document rendering mode (document.compatMode=' " + currentMode + "').<br>Modify your application's host HTML page doctype, or update your custom 'document.compatMode' configuration property settings.";
        if (severity == Severity.ERROR) {
            throw new RuntimeException(message);
        }
        GWT.log(message);
    }

    public static enum Severity {
        ERROR,
        IGNORE,
        WARN;

    }

    public static interface DocumentModeProperty {
        public String[] getAllowedDocumentModes();

        public Severity getDocumentModeSeverity();
    }
}

