/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.response;

import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.AbstractResponse;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.Response;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class ErrorResponse
extends AbstractResponse
implements Response,
DsmlDecorator<Response> {
    private static final String ERROR_RESPONSE_TAG = "errorResponse";
    private ErrorResponseType errorType;
    private String message;
    private int requestID;

    public ErrorResponse(int id, MessageTypeEnum type) {
        super(id, type);
    }

    public ErrorResponse(int requestID, ErrorResponseType type, String message) {
        super(requestID, null);
        this.requestID = requestID;
        this.errorType = type;
        this.message = message;
    }

    @Override
    public Element toDsml(Element root) {
        Element element = null;
        element = root != null ? root.addElement(ERROR_RESPONSE_TAG) : new DefaultElement(ERROR_RESPONSE_TAG);
        if (this.requestID != 0) {
            element.addAttribute("requestID", Integer.toString(this.requestID));
        }
        element.addAttribute("type", this.getTypeDescr(this.errorType));
        if (this.message != null && !"".equals(this.message)) {
            Element messageElement = element.addElement("message");
            messageElement.addText(this.message);
        }
        return element;
    }

    public String getTypeDescr(ErrorResponseType type) {
        if (type.equals((Object)ErrorResponseType.NOT_ATTEMPTED)) {
            return "notAttempted";
        }
        if (type.equals((Object)ErrorResponseType.COULD_NOT_CONNECT)) {
            return "couldNotConnect";
        }
        if (type.equals((Object)ErrorResponseType.CONNECTION_CLOSED)) {
            return "connectionClosed";
        }
        if (type.equals((Object)ErrorResponseType.MALFORMED_REQUEST)) {
            return "malformedRequest";
        }
        if (type.equals((Object)ErrorResponseType.GATEWAY_INTERNAL_ERROR)) {
            return "gatewayInternalError";
        }
        if (type.equals((Object)ErrorResponseType.AUTHENTICATION_FAILED)) {
            return "authenticationFailed";
        }
        if (type.equals((Object)ErrorResponseType.UNRESOLVABLE_URI)) {
            return "unresolvableURI";
        }
        if (type.equals((Object)ErrorResponseType.OTHER)) {
            return "other";
        }
        return "unknown";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public ErrorResponseType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorResponseType errorType) {
        this.errorType = errorType;
    }

    public LdapApiService getCodecService() {
        throw new IllegalArgumentException("This should not be a decorator but seems it was made into one. We need to do something aboutthis if this exception is being raise.");
    }

    @Override
    public Response getDecorated() {
        return this;
    }

    public static enum ErrorResponseType {
        NOT_ATTEMPTED,
        COULD_NOT_CONNECT,
        CONNECTION_CLOSED,
        MALFORMED_REQUEST,
        GATEWAY_INTERNAL_ERROR,
        AUTHENTICATION_FAILED,
        UNRESOLVABLE_URI,
        OTHER;

    }
}

