<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Mailshare.
 */
class Mailshare extends DirBaseValue {

  /*
   * @type String
   */
  public $name;

  /*
   * @type Integer
   */
  public $quota;

  /*
   * @type MailboxRouting
   */
  public $routing;

  /*
   * @type VCard
   */
  public $card;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->name = "";
    $this->quota = null;
    $this->card =   new VCard();
  }

  public function toMap() {
    $data = array(    
        "name" => empty($this->name) ? null : $this->name,    
        "quota" => empty($this->quota) ? null : $this->quota,    
        "routing" => empty($this->routing) ? null : $this->routing,    
        "card" => empty($this->card) ? null : $this->card);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
