<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * IdentityDescription.
 */
class IdentityDescription  {

  /*
   * @type String
   */
  public $mbox;

  /*
   * @type String
   */
  public $id;

  /*
   * @type String
   */
  public $email;

  /*
   * @type Boolean
   */
  public $emailIsDefault;

  /*
   * @type String
   */
  public $name;

  /*
   * @type Boolean
   */
  public $isDefault;

  /*
   * @type String
   */
  public $displayname;

  /*
   * @type String
   */
  public $signature;

  /*
   * @type String
   */
  public $mboxName;

  /*
   * Constructor
   */
  public function __construct() {
    $this->mbox = "";
    $this->id = "";
    $this->email = "";
    $this->emailIsDefault = false;
    $this->name = "";
    $this->isDefault = false;
    $this->displayname = "";
    $this->signature = "";
    $this->mboxName = "";
  }

  public function toMap() {
    $data = array(    
        "mbox" => empty($this->mbox) ? null : $this->mbox,    
        "id" => empty($this->id) ? null : $this->id,    
        "email" => empty($this->email) ? null : $this->email,    
        "emailIsDefault" => empty($this->emailIsDefault) ? null : $this->emailIsDefault,    
        "name" => empty($this->name) ? null : $this->name,    
        "isDefault" => empty($this->isDefault) ? null : $this->isDefault,    
        "displayname" => empty($this->displayname) ? null : $this->displayname,    
        "signature" => empty($this->signature) ? null : $this->signature,    
        "mboxName" => empty($this->mboxName) ? null : $this->mboxName);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
